/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import io.micronaut.configuration.graphql.GraphQLExecutionInputCustomizer;
import io.micronaut.configuration.graphql.GraphQLInvocation;
import io.micronaut.configuration.graphql.GraphQLInvocationData;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.reactivex.Flowable;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.dataloader.DataLoaderRegistry;
import org.reactivestreams.Publisher;

@Singleton
public class DefaultGraphQLInvocation
implements GraphQLInvocation {
    private final GraphQL graphQL;
    private final GraphQLExecutionInputCustomizer graphQLExecutionInputCustomizer;
    private final Provider<DataLoaderRegistry> dataLoaderRegistry;

    public DefaultGraphQLInvocation(GraphQL graphQL, @Nullable GraphQLExecutionInputCustomizer graphQLExecutionInputCustomizer, @Nullable Provider<DataLoaderRegistry> dataLoaderRegistry) {
        this.graphQL = graphQL;
        this.graphQLExecutionInputCustomizer = graphQLExecutionInputCustomizer;
        this.dataLoaderRegistry = dataLoaderRegistry;
    }

    @Override
    public Publisher<ExecutionResult> invoke(GraphQLInvocationData invocationData, HttpRequest httpRequest) {
        ExecutionInput.Builder executionInputBuilder = ExecutionInput.newExecutionInput().query(invocationData.getQuery()).operationName(invocationData.getOperationName()).variables(invocationData.getVariables());
        if (this.dataLoaderRegistry != null) {
            executionInputBuilder.dataLoaderRegistry((DataLoaderRegistry)this.dataLoaderRegistry.get());
        }
        ExecutionInput executionInput = executionInputBuilder.build();
        return Flowable.fromPublisher(this.graphQLExecutionInputCustomizer.customize(executionInput, httpRequest)).flatMap(customizedExecutionInput -> Publishers.fromCompletableFuture(() -> {
            try {
                return this.graphQL.executeAsync(customizedExecutionInput);
            }
            catch (Throwable e) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
        }));
    }
}

