/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws;

import io.micronaut.configuration.graphql.ws.GraphQLWsOperations;
import io.micronaut.configuration.graphql.ws.GraphQLWsRequest;
import io.micronaut.configuration.graphql.ws.GraphQLWsResponse;
import io.micronaut.websocket.WebSocketSession;
import io.reactivex.Flowable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

@Singleton
class GraphQLWsState {
    private ConcurrentSkipListSet<String> activeSessions = new ConcurrentSkipListSet();
    private ConcurrentHashMap<String, GraphQLWsOperations> activeOperations = new ConcurrentHashMap();

    GraphQLWsState() {
    }

    void activateSession(WebSocketSession session) {
        this.activeSessions.add(session.getId());
    }

    boolean isActive(WebSocketSession session) {
        return this.activeSessions.contains(session.getId());
    }

    void init(WebSocketSession session) {
        this.activeOperations.putIfAbsent(session.getId(), new GraphQLWsOperations());
    }

    Publisher<GraphQLWsResponse> terminateSession(WebSocketSession session) {
        this.activeSessions.remove(session.getId());
        Optional.ofNullable(this.activeOperations.remove(session.getId())).ifPresent(GraphQLWsOperations::cancelAll);
        return Flowable.empty();
    }

    void saveOperation(String operationId, WebSocketSession session, Function<String, Subscription> starter) {
        Optional.ofNullable(session).map(WebSocketSession::getId).map(id -> this.activeOperations.get(id)).ifPresent(graphQLWsOperations -> graphQLWsOperations.addSubscription(operationId, starter));
    }

    Publisher<GraphQLWsResponse> stopOperation(GraphQLWsRequest request, WebSocketSession session) {
        String sessionId = session.getId();
        String operationId = request.getId();
        if (operationId == null || sessionId == null) {
            return Flowable.empty();
        }
        boolean removed = Optional.ofNullable(this.activeOperations.get(sessionId)).map(graphQLWsOperations -> {
            graphQLWsOperations.cancelOperation(operationId);
            return graphQLWsOperations.removeCompleted(operationId);
        }).orElse(false);
        return removed ? Flowable.just((Object)new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_COMPLETE, operationId)) : Flowable.empty();
    }

    boolean removeCompleted(String operationId, WebSocketSession session) {
        return Optional.ofNullable(session).map(WebSocketSession::getId).map(sessionId -> this.activeOperations.get(sessionId)).map(graphQLWsOperations -> graphQLWsOperations.removeCompleted(operationId)).orElse(false);
    }

    boolean operationExists(GraphQLWsRequest request, WebSocketSession session) {
        return Optional.ofNullable(session).map(WebSocketSession::getId).map(sessionId -> this.activeOperations.get(sessionId)).map(graphQLWsOperations -> graphQLWsOperations.operationExists(request)).orElse(false);
    }
}

