/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.configuration.graphql.GraphQLJsonSerializer;
import jakarta.inject.Singleton;
import java.io.IOException;

@Singleton
public class JacksonGraphQLJsonSerializer
implements GraphQLJsonSerializer {
    private final ObjectMapper objectMapper;

    public JacksonGraphQLJsonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String serialize(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing object to JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public <T> T deserialize(String json, Class<T> requiredType) {
        try {
            return (T)this.objectMapper.readValue(json, requiredType);
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserializing object from JSON: " + e.getMessage(), e);
        }
    }
}

