/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws;

import io.micronaut.configuration.graphql.GraphQLJsonSerializer;
import io.micronaut.configuration.graphql.ws.GraphQLWsMessageHandler;
import io.micronaut.configuration.graphql.ws.GraphQLWsRequest;
import io.micronaut.configuration.graphql.ws.GraphQLWsResponse;
import io.micronaut.configuration.graphql.ws.GraphQLWsState;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.annotation.OnClose;
import io.micronaut.websocket.annotation.OnError;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.annotation.OnOpen;
import io.micronaut.websocket.annotation.ServerWebSocket;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@ServerWebSocket(value="${graphql.graphql-ws.path:/graphql-ws}", subprotocols="graphql-ws")
@Requires(property="graphql.graphql-ws.enabled", value="true", defaultValue="false")
public class GraphQLWsController {
    static final String HTTP_REQUEST_KEY = "httpRequest";
    private static final Logger LOG = LoggerFactory.getLogger(GraphQLWsController.class);
    private final GraphQLWsMessageHandler messageHandler;
    private final GraphQLWsState state;
    private final GraphQLJsonSerializer graphQLJsonSerializer;
    private final GraphQLWsResponse errorMessage;

    public GraphQLWsController(GraphQLWsMessageHandler messageHandler, GraphQLWsState state, GraphQLJsonSerializer graphQLJsonSerializer) {
        this.messageHandler = messageHandler;
        this.state = state;
        this.graphQLJsonSerializer = graphQLJsonSerializer;
        this.errorMessage = new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_CONNECTION_ERROR);
    }

    @OnOpen
    public void onOpen(WebSocketSession session, HttpRequest request) {
        session.put((CharSequence)HTTP_REQUEST_KEY, (Object)request);
        this.state.init(session);
        LOG.trace("Opened websocket connection with id {}", (Object)session.getId());
    }

    @OnMessage
    public Publisher<GraphQLWsResponse> onMessage(String message, WebSocketSession session) {
        try {
            GraphQLWsRequest request = this.graphQLJsonSerializer.deserialize(message, GraphQLWsRequest.class);
            if (request.getType() == null) {
                LOG.warn("Type was null on operation message");
                return this.send((Publisher<GraphQLWsResponse>)Flux.just((Object)this.errorMessage), session);
            }
            return this.send(this.messageHandler.handleMessage(request, session), session);
        }
        catch (Exception e) {
            LOG.warn("Error deserializing message received from client: {}", (Object)message, (Object)e);
            return this.send((Publisher<GraphQLWsResponse>)Flux.just((Object)this.errorMessage), session);
        }
    }

    @OnClose
    public Publisher<GraphQLWsResponse> onClose(WebSocketSession session, CloseReason closeReason) {
        LOG.trace("Closed websocket connection with id {} with reason {}", (Object)session.getId(), (Object)closeReason);
        return this.send(this.state.terminateSession(session), session);
    }

    @OnError
    public Publisher<GraphQLWsResponse> onError(WebSocketSession session, Throwable t) {
        LOG.debug("Error websocket connection with id {} with error {}", (Object)session.getId(), (Object)t.getMessage());
        return this.send(this.state.terminateSession(session), session);
    }

    private Publisher<GraphQLWsResponse> send(Publisher<GraphQLWsResponse> publisher, WebSocketSession session) {
        return Publishers.then(publisher, response -> {
            if (session.isOpen()) {
                session.sendSync((Object)this.graphQLJsonSerializer.serialize(response));
            }
        });
    }
}

