/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws;

import io.micronaut.configuration.graphql.GraphQLJsonSerializer;
import io.micronaut.configuration.graphql.ws.GraphQLWsResponse;
import io.micronaut.configuration.graphql.ws.GraphQLWsState;
import io.micronaut.context.annotation.Requires;
import io.micronaut.scheduling.annotation.Scheduled;
import io.micronaut.websocket.WebSocketBroadcaster;
import jakarta.inject.Singleton;

@Singleton
@Requires(property="graphql-ws.keep-alive-enabled", value="true", defaultValue="true")
public class GraphQLWsKeepAlive {
    private final WebSocketBroadcaster broadcaster;
    private final GraphQLWsState state;
    private final String kaMessage;

    public GraphQLWsKeepAlive(WebSocketBroadcaster broadcaster, GraphQLWsState state, GraphQLJsonSerializer graphQLJsonSerializer) {
        this.broadcaster = broadcaster;
        this.state = state;
        this.kaMessage = graphQLJsonSerializer.serialize(new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_CONNECTION_KEEP_ALIVE));
    }

    @Scheduled(fixedDelay="${graphql.graphql-ws.keep-alive-interval:15s}")
    public void keepAliveSender() {
        this.broadcaster.broadcastSync((Object)this.kaMessage, this.state::isActive);
    }
}

