/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws;

import graphql.ExecutionResult;
import io.micronaut.configuration.graphql.GraphQLExecutionResultHandler;
import io.micronaut.configuration.graphql.GraphQLInvocation;
import io.micronaut.configuration.graphql.GraphQLInvocationData;
import io.micronaut.configuration.graphql.GraphQLRequestBody;
import io.micronaut.configuration.graphql.GraphQLResponseBody;
import io.micronaut.configuration.graphql.ws.GraphQLWsConfiguration;
import io.micronaut.configuration.graphql.ws.GraphQLWsRequest;
import io.micronaut.configuration.graphql.ws.GraphQLWsResponse;
import io.micronaut.configuration.graphql.ws.GraphQLWsSender;
import io.micronaut.configuration.graphql.ws.GraphQLWsState;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.websocket.WebSocketSession;
import jakarta.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Singleton
public class GraphQLWsMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GraphQLWsMessageHandler.class);
    private final GraphQLWsConfiguration graphQLWsConfiguration;
    private final GraphQLWsState state;
    private final GraphQLInvocation graphQLInvocation;
    private final GraphQLExecutionResultHandler graphQLExecutionResultHandler;
    private final GraphQLWsSender responseSender;

    public GraphQLWsMessageHandler(GraphQLWsConfiguration graphQLWsConfiguration, GraphQLWsState state, GraphQLInvocation graphQLInvocation, GraphQLExecutionResultHandler graphQLExecutionResultHandler, GraphQLWsSender responseSender) {
        this.graphQLWsConfiguration = graphQLWsConfiguration;
        this.state = state;
        this.graphQLInvocation = graphQLInvocation;
        this.graphQLExecutionResultHandler = graphQLExecutionResultHandler;
        this.responseSender = responseSender;
    }

    public Publisher<GraphQLWsResponse> handleMessage(GraphQLWsRequest request, WebSocketSession session) {
        switch (request.getType()) {
            case GQL_CONNECTION_INIT: {
                return this.init(session);
            }
            case GQL_START: {
                return this.startOperation(request, session);
            }
            case GQL_STOP: {
                return this.state.stopOperation(request, session);
            }
            case GQL_CONNECTION_TERMINATE: {
                return this.state.terminateSession(session);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)request.getType()));
    }

    private Publisher<GraphQLWsResponse> init(WebSocketSession session) {
        if (this.graphQLWsConfiguration.keepAliveEnabled) {
            this.state.activateSession(session);
            return Flux.just((Object[])new GraphQLWsResponse[]{new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_CONNECTION_ACK), new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_CONNECTION_KEEP_ALIVE)});
        }
        return Flux.just((Object)new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_CONNECTION_ACK));
    }

    private Publisher<GraphQLWsResponse> startOperation(GraphQLWsRequest request, WebSocketSession session) {
        if (request.getId() == null) {
            LOG.warn("GraphQL operation id is required with type start");
            return Flux.just((Object)new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_ERROR));
        }
        if (this.state.operationExists(request, session)) {
            LOG.info("Already subscribed to operation {} in session {}", (Object)request.getId(), (Object)session.getId());
            return Flux.empty();
        }
        GraphQLRequestBody payload = request.getPayload();
        if (payload == null || StringUtils.isEmpty((CharSequence)payload.getQuery())) {
            LOG.info("Payload was null or query empty for operation {} in session {}", (Object)request.getId(), (Object)session.getId());
            return Flux.just((Object)new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_ERROR, request.getId()));
        }
        return this.executeRequest(request.getId(), payload, session);
    }

    private Publisher<GraphQLWsResponse> executeRequest(String operationId, GraphQLRequestBody payload, WebSocketSession session) {
        GraphQLInvocationData invocationData = new GraphQLInvocationData(payload.getQuery(), payload.getOperationName(), payload.getVariables());
        HttpRequest httpRequest = (HttpRequest)session.get((CharSequence)"httpRequest", HttpRequest.class).orElseThrow(() -> new RuntimeException("HttpRequest could not be retrieved from websocket session"));
        Publisher<ExecutionResult> executionResult = this.graphQLInvocation.invoke(invocationData, httpRequest, null);
        Publisher<GraphQLResponseBody> responseBody = this.graphQLExecutionResultHandler.handleExecutionResult(executionResult);
        return Flux.from(responseBody).flatMap(body -> this.responseSender.send(operationId, (GraphQLResponseBody)body, session));
    }
}

