/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws;

import io.micronaut.configuration.graphql.ws.GraphQLWsRequest;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.reactivestreams.Subscription;

@Singleton
class GraphQLWsOperations {
    private ConcurrentHashMap<String, Subscription> activeOperations = new ConcurrentHashMap();

    GraphQLWsOperations() {
    }

    void cancelAll() {
        for (Subscription subscription : this.activeOperations.values()) {
            subscription.cancel();
        }
    }

    void addSubscription(String operationId, Function<String, Subscription> starter) {
        this.activeOperations.computeIfAbsent(operationId, starter);
    }

    void cancelOperation(String operationId) {
        Optional.ofNullable(this.activeOperations.get(operationId)).ifPresent(Subscription::cancel);
    }

    boolean removeCompleted(String operationId) {
        if (operationId != null) {
            return this.activeOperations.remove(operationId) != null;
        }
        return false;
    }

    boolean operationExists(GraphQLWsRequest request) {
        return Optional.ofNullable(request).map(GraphQLWsRequest::getId).map(id -> this.activeOperations.containsKey(id)).orElse(false);
    }
}

