/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws;

import io.micronaut.configuration.graphql.GraphQLRequestBody;
import io.micronaut.core.annotation.Nullable;

public class GraphQLWsRequest {
    private static final String TYPE_ERROR_MESSAGE = "Could not map %s to a known client type.";
    private ClientType type;
    @Nullable
    private String id;
    @Nullable
    private GraphQLRequestBody payload;

    public ClientType getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = this.fromString(type);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public GraphQLRequestBody getPayload() {
        return this.payload;
    }

    public void setPayload(@Nullable GraphQLRequestBody payload) {
        this.payload = payload;
    }

    private ClientType fromString(String type) {
        for (ClientType clientType : ClientType.values()) {
            if (!clientType.getType().equals(type)) continue;
            return clientType;
        }
        throw new RuntimeException(String.format(TYPE_ERROR_MESSAGE, type));
    }

    public static enum ClientType {
        GQL_CONNECTION_INIT("connection_init"),
        GQL_START("start"),
        GQL_STOP("stop"),
        GQL_CONNECTION_TERMINATE("connection_terminate");

        private String type;

        private ClientType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

