/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws;

import graphql.ExecutionResult;
import io.micronaut.configuration.graphql.GraphQLJsonSerializer;
import io.micronaut.configuration.graphql.GraphQLResponseBody;
import io.micronaut.configuration.graphql.ws.GraphQLWsResponse;
import io.micronaut.configuration.graphql.ws.GraphQLWsState;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.websocket.WebSocketSession;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Singleton
public class GraphQLWsSender {
    private static final Logger LOG = LoggerFactory.getLogger(GraphQLWsSender.class);
    private final GraphQLWsState state;
    private final GraphQLJsonSerializer graphQLJsonSerializer;

    public GraphQLWsSender(GraphQLWsState state, GraphQLJsonSerializer graphQLJsonSerializer) {
        this.state = state;
        this.graphQLJsonSerializer = graphQLJsonSerializer;
    }

    Publisher<GraphQLWsResponse> send(String operationId, GraphQLResponseBody responseBody, WebSocketSession session) {
        Object dataObject = responseBody.getSpecification().get("data");
        if (dataObject instanceof Publisher) {
            this.startSubscription(operationId, (Publisher<ExecutionResult>)((Publisher)dataObject), session);
            return Flux.empty();
        }
        return Flux.just((Object[])new GraphQLWsResponse[]{this.toGraphQLWsResponse(operationId, responseBody), new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_COMPLETE, operationId)});
    }

    private GraphQLWsResponse toGraphQLWsResponse(String operationId, GraphQLResponseBody responseBody) {
        if (this.hasErrors(responseBody)) {
            return new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_ERROR, operationId, responseBody);
        }
        return new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_DATA, operationId, responseBody);
    }

    private boolean hasErrors(GraphQLResponseBody responseBody) {
        Object errorObject = responseBody.getSpecification().get("errors");
        if (errorObject instanceof Collection) {
            return !((Collection)errorObject).isEmpty();
        }
        return false;
    }

    private Function<String, Subscription> starter(Publisher<ExecutionResult> publisher, WebSocketSession session) {
        return operationId -> {
            SendSubscriber subscriber = new SendSubscriber((String)operationId, session);
            publisher.subscribe((Subscriber)subscriber);
            return subscriber.getSubscription();
        };
    }

    private void startSubscription(String operationId, Publisher<ExecutionResult> publisher, WebSocketSession session) {
        this.state.saveOperation(operationId, session, this.starter(publisher, session));
    }

    private final class SendSubscriber
    extends CompletionAwareSubscriber<ExecutionResult> {
        private final String operationId;
        private final WebSocketSession session;

        private SendSubscriber(String operationId, WebSocketSession session) {
            this.operationId = operationId;
            this.session = session;
        }

        Subscription getSubscription() {
            return this.subscription;
        }

        protected void doOnSubscribe(Subscription subscription) {
            LOG.info("Subscribed to results for to operation {} in session {}", (Object)this.operationId, (Object)this.session.getId());
            subscription.request(1L);
        }

        protected void doOnNext(ExecutionResult message) {
            this.convertAndSend(message);
            this.subscription.request(1L);
        }

        protected void doOnError(Throwable t) {
            LOG.warn("Error in SendSubscriber", t);
            this.send(new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_ERROR, this.operationId));
        }

        protected void doOnComplete() {
            LOG.info("Completed results for operation {} in session {}", (Object)this.operationId, (Object)this.session.getId());
            if (GraphQLWsSender.this.state.removeCompleted(this.operationId, this.session)) {
                this.send(new GraphQLWsResponse(GraphQLWsResponse.ServerType.GQL_COMPLETE, this.operationId));
            }
        }

        private void convertAndSend(ExecutionResult executionResult) {
            GraphQLWsResponse response = GraphQLWsSender.this.toGraphQLWsResponse(this.operationId, new GraphQLResponseBody(executionResult.toSpecification()));
            this.send(response);
        }

        private void send(GraphQLWsResponse response) {
            if (this.session.isOpen()) {
                this.session.sendSync((Object)GraphQLWsSender.this.graphQLJsonSerializer.serialize(response));
            }
        }
    }
}

