/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql;

import graphql.ExecutionResult;
import io.micronaut.configuration.graphql.GraphQLExecutionResultHandler;
import io.micronaut.configuration.graphql.GraphQLInvocation;
import io.micronaut.configuration.graphql.GraphQLInvocationData;
import io.micronaut.configuration.graphql.GraphQLJsonSerializer;
import io.micronaut.configuration.graphql.GraphQLRequestBody;
import io.micronaut.configuration.graphql.GraphQLResponseBody;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.exceptions.HttpStatusException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Controller(value="${graphql.path:/graphql}")
public class GraphQLController {
    private final GraphQLInvocation graphQLInvocation;
    private final GraphQLExecutionResultHandler graphQLExecutionResultHandler;
    private final GraphQLJsonSerializer graphQLJsonSerializer;

    public GraphQLController(GraphQLInvocation graphQLInvocation, GraphQLExecutionResultHandler graphQLExecutionResultHandler, GraphQLJsonSerializer graphQLJsonSerializer) {
        this.graphQLInvocation = graphQLInvocation;
        this.graphQLExecutionResultHandler = graphQLExecutionResultHandler;
        this.graphQLJsonSerializer = graphQLJsonSerializer;
    }

    @Get(produces={"application/json"}, single=true)
    public Publisher<MutableHttpResponse<String>> get(@QueryValue(value="query") String query, @Nullable @QueryValue(value="operationName") String operationName, @Nullable @QueryValue(value="variables") String variables, HttpRequest httpRequest) {
        return this.executeRequest(query, operationName, this.convertVariablesJson(variables), httpRequest);
    }

    @Post(consumes={"*/*"}, produces={"application/json"}, single=true)
    public Publisher<MutableHttpResponse<String>> post(@Nullable @QueryValue(value="query") String query, @Nullable @QueryValue(value="operationName") String operationName, @Nullable @QueryValue(value="variables") String variables, @Nullable @Body String body, HttpRequest httpRequest) {
        Optional opt = httpRequest.getContentType();
        MediaType contentType = opt.orElse(null);
        if (body == null) {
            body = "";
        }
        if (MediaType.APPLICATION_JSON_TYPE.equals((Object)contentType)) {
            GraphQLRequestBody request = this.graphQLJsonSerializer.deserialize(body, GraphQLRequestBody.class);
            if (request.getQuery() == null) {
                request.setQuery("");
            }
            return this.executeRequest(request.getQuery(), request.getOperationName(), request.getVariables(), httpRequest);
        }
        if (query != null) {
            return this.executeRequest(query, operationName, this.convertVariablesJson(variables), httpRequest);
        }
        if (MediaType.APPLICATION_GRAPHQL_TYPE.equals((Object)contentType)) {
            return this.executeRequest(body, null, null, httpRequest);
        }
        throw new HttpStatusException(HttpStatus.UNPROCESSABLE_ENTITY, "Could not process GraphQL request");
    }

    private Map<String, Object> convertVariablesJson(String jsonMap) {
        if (jsonMap == null) {
            return Collections.emptyMap();
        }
        return this.graphQLJsonSerializer.deserialize(jsonMap, Map.class);
    }

    private Publisher<MutableHttpResponse<String>> executeRequest(String query, String operationName, Map<String, Object> variables, HttpRequest httpRequest) {
        GraphQLInvocationData invocationData = new GraphQLInvocationData(query, operationName, variables);
        MutableHttpResponse httpResponse = HttpResponse.status((HttpStatus)HttpStatus.OK);
        Publisher<ExecutionResult> executionResult = this.graphQLInvocation.invoke(invocationData, httpRequest, (MutableHttpResponse<String>)httpResponse);
        Publisher<GraphQLResponseBody> responseBody = this.graphQLExecutionResultHandler.handleExecutionResult(executionResult);
        return Publishers.map(responseBody, graphQLResponseBody -> httpResponse.body((Object)this.graphQLJsonSerializer.serialize(graphQLResponseBody)));
    }
}

