/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import io.micronaut.configuration.graphql.GraphQLExecutionInputCustomizer;
import io.micronaut.configuration.graphql.GraphQLInvocation;
import io.micronaut.configuration.graphql.GraphQLInvocationData;
import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import jakarta.inject.Singleton;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoaderRegistry;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
public class DefaultGraphQLInvocation
implements GraphQLInvocation {
    private final GraphQL graphQL;
    private final GraphQLExecutionInputCustomizer graphQLExecutionInputCustomizer;
    private final BeanProvider<DataLoaderRegistry> dataLoaderRegistry;

    public DefaultGraphQLInvocation(GraphQL graphQL, GraphQLExecutionInputCustomizer graphQLExecutionInputCustomizer, @Nullable BeanProvider<DataLoaderRegistry> dataLoaderRegistry) {
        this.graphQL = graphQL;
        this.graphQLExecutionInputCustomizer = graphQLExecutionInputCustomizer;
        this.dataLoaderRegistry = dataLoaderRegistry;
    }

    @Override
    public Publisher<ExecutionResult> invoke(GraphQLInvocationData invocationData, HttpRequest httpRequest, @Nullable MutableHttpResponse<String> httpResponse) {
        ExecutionInput.Builder executionInputBuilder = ExecutionInput.newExecutionInput().query(invocationData.getQuery()).operationName(invocationData.getOperationName()).variables(invocationData.getVariables());
        if (this.dataLoaderRegistry != null) {
            executionInputBuilder.dataLoaderRegistry((DataLoaderRegistry)this.dataLoaderRegistry.get());
        }
        ExecutionInput executionInput = executionInputBuilder.build();
        return Flux.from(this.graphQLExecutionInputCustomizer.customize(executionInput, httpRequest, httpResponse)).flatMap(customizedExecutionInput -> Mono.fromFuture(() -> {
            try {
                return this.graphQL.executeAsync(customizedExecutionInput);
            }
            catch (Throwable e) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
        }));
    }
}

