/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql;

import io.micronaut.configuration.graphql.GraphQLConfiguration;
import io.micronaut.configuration.graphql.ws.apollo.GraphQLApolloWsConfiguration;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.core.value.MapPropertyResolver;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

@Controller(value="${graphql.graphiql.path:/graphiql}")
@Requires(property="graphql.graphiql.enabled", value="true", defaultValue="false")
public class GraphiQLController {
    private final GraphQLConfiguration graphQLConfiguration;
    private final GraphQLConfiguration.GraphiQLConfiguration graphiQLConfiguration;
    private final GraphQLApolloWsConfiguration graphQLApolloWsConfiguration;
    private final ResourceResolver resourceResolver;
    private final ConversionService conversionService;
    private final String rawTemplate;
    private final Supplier<String> resolvedTemplate;

    public GraphiQLController(GraphQLConfiguration graphQLConfiguration, GraphQLApolloWsConfiguration graphQLApolloWsConfiguration, ResourceResolver resourceResolver, ConversionService conversionService) {
        this.graphQLConfiguration = graphQLConfiguration;
        this.graphiQLConfiguration = graphQLConfiguration.getGraphiql();
        this.graphQLApolloWsConfiguration = graphQLApolloWsConfiguration;
        this.resourceResolver = resourceResolver;
        this.conversionService = conversionService;
        this.rawTemplate = this.loadTemplate(this.graphiQLConfiguration.getTemplatePath());
        this.resolvedTemplate = SupplierUtil.memoized(this::resolvedTemplate);
    }

    @Get(produces={"text/html;charset=UTF-8"})
    public String get() {
        return this.resolvedTemplate.get();
    }

    private String loadTemplate(String templateFile) {
        Optional template = this.resourceResolver.getResourceAsStream(templateFile);
        if (template.isPresent()) {
            String string;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)template.get(), StandardCharsets.UTF_8));
            try {
                string = IOUtils.readText((BufferedReader)in);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigurationException("Cannot read GraphiQL template: " + templateFile, (Throwable)e);
                }
            }
            in.close();
            return string;
        }
        throw new ConfigurationException("Cannot find GraphiQL template: " + templateFile);
    }

    private String resolvedTemplate() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("graphiqlVersion", this.graphiQLConfiguration.getVersion());
        parameters.put("graphiqlExplorerPluginVersion", this.graphiQLConfiguration.getExplorerPluginVersion());
        parameters.put("graphqlPath", this.graphQLConfiguration.getPath());
        String graphQLWsPath = this.graphQLApolloWsConfiguration.isEnabled() ? this.graphQLApolloWsConfiguration.getPath() : "";
        parameters.put("graphqlWsPath", graphQLWsPath);
        parameters.put("pageTitle", this.graphiQLConfiguration.getPageTitle());
        parameters.put("graphiqlPath", this.graphiQLConfiguration.getPath());
        if (this.graphiQLConfiguration.getTemplateParameters() != null) {
            this.graphiQLConfiguration.getTemplateParameters().forEach((name, value) -> parameters.put(NameUtils.decapitalize((String)NameUtils.dehyphenate((String)name)), (String)value));
        }
        return this.replaceParameters(this.rawTemplate, parameters);
    }

    private String replaceParameters(String str, Map<String, String> parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(parameters);
        MapPropertyResolver propertyResolver = new MapPropertyResolver(map);
        DefaultPropertyPlaceholderResolver propertyPlaceholderResolver = new DefaultPropertyPlaceholderResolver((PropertyResolver)propertyResolver, this.conversionService);
        return (String)propertyPlaceholderResolver.resolvePlaceholders(str).get();
    }
}

