/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql;

import io.micronaut.configuration.graphql.GraphQLJsonSerializer;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonMapper;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

@Singleton
public class JacksonGraphQLJsonSerializer
implements GraphQLJsonSerializer {
    private final JsonMapper jsonMapper;

    public JacksonGraphQLJsonSerializer(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public String serialize(Object object) {
        try {
            return new String(this.jsonMapper.writeValueAsBytes(object), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing object to JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public <T> T deserialize(String json, Class<T> requiredType) {
        try {
            return (T)this.jsonMapper.readValue(json, Argument.of(requiredType));
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserializing object from JSON: " + e.getMessage(), e);
        }
    }
}

