/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.micronaut.configuration.graphql.ws.CompleteMessage;
import io.micronaut.configuration.graphql.ws.ConnectionAckMessage;
import io.micronaut.configuration.graphql.ws.ConnectionInitMessage;
import io.micronaut.configuration.graphql.ws.ErrorMessage;
import io.micronaut.configuration.graphql.ws.NextMessage;
import io.micronaut.configuration.graphql.ws.PingMessage;
import io.micronaut.configuration.graphql.ws.PongMessage;
import io.micronaut.configuration.graphql.ws.SubscribeMessage;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ConnectionInitMessage.class, name="connection_init"), @JsonSubTypes.Type(value=ConnectionAckMessage.class, name="connection_ack"), @JsonSubTypes.Type(value=PingMessage.class, name="ping"), @JsonSubTypes.Type(value=PongMessage.class, name="pong"), @JsonSubTypes.Type(value=SubscribeMessage.class, name="subscribe"), @JsonSubTypes.Type(value=NextMessage.class, name="next"), @JsonSubTypes.Type(value=ErrorMessage.class, name="error"), @JsonSubTypes.Type(value=CompleteMessage.class, name="complete")})
public abstract class Message {
    @JsonIgnore
    @NonNull
    abstract String getMessageType();

    protected void checkRequiredId(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("'id' is required for messages with type '" + this.getMessageType() + "'.");
        }
    }

    static final class Types {
        static final String CONNECTION_INIT = "connection_init";
        static final String CONNECTION_ACK = "connection_ack";
        static final String PING = "ping";
        static final String PONG = "pong";
        static final String SUBSCRIBE = "subscribe";
        static final String NEXT = "next";
        static final String ERROR = "error";
        static final String COMPLETE = "complete";

        private Types() {
        }
    }
}

