/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.configuration.graphql.ws.RequiredPayloadMessage;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.serde.annotation.Serdeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Serdeable
final class SubscribeMessage
extends RequiredPayloadMessage<Map<String, Object>> {
    @NonNull
    private final String id;

    @JsonCreator
    public SubscribeMessage(@NonNull @JsonProperty(value="id") String id, @NonNull @JsonProperty(value="payload") SubscribePayload payload) {
        super(payload.toMap());
        this.checkRequiredId(id);
        this.id = id;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @Override
    @JsonIgnore
    @NonNull
    String getMessageType() {
        return "subscribe";
    }

    @JsonIgnore
    @NonNull
    SubscribePayload getSubscribePayload() {
        return SubscribePayload.fromMap((Map)this.getPayload());
    }

    @Serdeable
    public static class SubscribePayload {
        @NonNull
        private final String query;
        @Nullable
        private String operationName;
        @Nullable
        private Map<String, Object> variables;
        @Nullable
        private Map<String, Object> extensions;

        @JsonCreator
        public SubscribePayload(@NonNull @JsonProperty(value="query") String query) {
            if (StringUtils.isEmpty((CharSequence)query)) {
                throw new IllegalArgumentException("The 'query' field is required in the payload of message type 'subscribe'");
            }
            this.query = query;
        }

        private SubscribePayload(@NonNull String query, @Nullable String operationName, @Nullable Map<String, Object> variables, @Nullable Map<String, Object> extensions) {
            this.query = query;
            this.operationName = operationName;
            this.variables = variables;
            this.extensions = extensions;
        }

        @NonNull
        public String getQuery() {
            return this.query;
        }

        @Nullable
        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(@Nullable String operationName) {
            this.operationName = operationName;
        }

        @Nullable
        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public void setVariables(@Nullable Map<String, Object> variables) {
            this.variables = variables;
        }

        @Nullable
        public Map<String, Object> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(@Nullable Map<String, Object> extensions) {
            this.extensions = extensions;
        }

        public Map<String, Object> toMap() {
            return Map.of("query", this.query, "operationName", Optional.ofNullable(this.operationName).orElse(""), "variables", Optional.ofNullable(this.variables).orElse(new HashMap()), "extensions", Optional.ofNullable(this.extensions).orElse(new HashMap()));
        }

        public static SubscribePayload fromMap(Map<String, Object> payload) {
            return new SubscribePayload((String)payload.get("query"), (String)payload.get("operationName"), (Map)payload.get("variables"), (Map)payload.get("extensions"));
        }
    }
}

