/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.graphql.ws.apollo;

import io.micronaut.configuration.graphql.GraphQLJsonSerializer;
import io.micronaut.configuration.graphql.ws.apollo.GraphQLApolloWsMessageHandler;
import io.micronaut.configuration.graphql.ws.apollo.GraphQLApolloWsRequest;
import io.micronaut.configuration.graphql.ws.apollo.GraphQLApolloWsResponse;
import io.micronaut.configuration.graphql.ws.apollo.GraphQLApolloWsState;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.annotation.OnClose;
import io.micronaut.websocket.annotation.OnError;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.annotation.OnOpen;
import io.micronaut.websocket.annotation.ServerWebSocket;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Deprecated(since="4.0")
@ServerWebSocket(value="${graphql.graphql-apollo-ws.path:/graphql-ws}", subprotocols="graphql-ws")
@Requires(property="graphql.graphql-apollo-ws.enabled", value="true", defaultValue="false")
public class GraphQLApolloWsController {
    static final String HTTP_REQUEST_KEY = "httpRequest";
    private static final Logger LOG = LoggerFactory.getLogger(GraphQLApolloWsController.class);
    private final GraphQLApolloWsMessageHandler messageHandler;
    private final GraphQLApolloWsState state;
    private final GraphQLJsonSerializer graphQLJsonSerializer;
    private final GraphQLApolloWsResponse errorMessage;

    public GraphQLApolloWsController(GraphQLApolloWsMessageHandler messageHandler, GraphQLApolloWsState state, GraphQLJsonSerializer graphQLJsonSerializer) {
        this.messageHandler = messageHandler;
        this.state = state;
        this.graphQLJsonSerializer = graphQLJsonSerializer;
        this.errorMessage = new GraphQLApolloWsResponse(GraphQLApolloWsResponse.ServerType.GQL_CONNECTION_ERROR);
    }

    @OnOpen
    public void onOpen(WebSocketSession session, HttpRequest request) {
        session.put((CharSequence)HTTP_REQUEST_KEY, (Object)request);
        this.state.init(session);
        LOG.trace("Opened websocket connection with id {}", (Object)session.getId());
    }

    @OnMessage
    public Publisher<GraphQLApolloWsResponse> onMessage(String message, WebSocketSession session) {
        try {
            GraphQLApolloWsRequest request = this.graphQLJsonSerializer.deserialize(message, GraphQLApolloWsRequest.class);
            if (request.getType() == null) {
                LOG.warn("Type was null on operation message");
                return this.send((Publisher<GraphQLApolloWsResponse>)Flux.just((Object)this.errorMessage), session);
            }
            return this.send(this.messageHandler.handleMessage(request, session), session);
        }
        catch (Exception e) {
            LOG.warn("Error deserializing message received from client: {}", (Object)message, (Object)e);
            return this.send((Publisher<GraphQLApolloWsResponse>)Flux.just((Object)this.errorMessage), session);
        }
    }

    @OnClose
    public Publisher<GraphQLApolloWsResponse> onClose(WebSocketSession session, CloseReason closeReason) {
        LOG.trace("Closed websocket connection with id {} with reason {}", (Object)session.getId(), (Object)closeReason);
        return this.send(this.state.terminateSession(session), session);
    }

    @OnError
    public Publisher<GraphQLApolloWsResponse> onError(WebSocketSession session, Throwable t) {
        LOG.debug("Error websocket connection with id {} with error {}", (Object)session.getId(), (Object)t.getMessage());
        return this.send(this.state.terminateSession(session), session);
    }

    private Publisher<GraphQLApolloWsResponse> send(Publisher<GraphQLApolloWsResponse> publisher, WebSocketSession session) {
        return Publishers.then(publisher, response -> {
            if (session.isOpen()) {
                session.sendSync((Object)this.graphQLJsonSerializer.serialize(response));
            }
        });
    }
}

