/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env.groovy;

import io.micronaut.context.env.AbstractPropertySourceLoader;
import io.micronaut.context.env.groovy.ConfigurationEvaluator;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class GroovyPropertySourceLoader
extends AbstractPropertySourceLoader {
    public int getOrder() {
        return -300;
    }

    protected void processInput(String name, InputStream input, Map<String, Object> finalMap) throws IOException {
        ConfigurationEvaluator evaluator = new ConfigurationEvaluator();
        try {
            Map<String, Object> configurationValues = evaluator.evaluate(input);
            if (!configurationValues.isEmpty()) {
                finalMap.putAll(configurationValues);
            }
        }
        catch (Throwable e) {
            throw new ConfigurationException("Exception occurred reading configuration [" + name + "]: " + e.getMessage(), e);
        }
    }

    protected Optional<InputStream> readInput(ResourceLoader resourceLoader, String fileName) {
        Stream urls = resourceLoader.getResources(fileName);
        Stream<URL> urlStream = urls.filter(url -> !url.getPath().contains("src/main/groovy"));
        Optional<URL> config = urlStream.findFirst();
        if (config.isPresent()) {
            return config.flatMap(url -> {
                try {
                    return Optional.of(url.openStream());
                }
                catch (IOException e) {
                    throw new ConfigurationException("Exception occurred reading configuration [" + fileName + "]: " + e.getMessage(), (Throwable)e);
                }
            });
        }
        return Optional.empty();
    }

    public Set<String> getExtensions() {
        return Collections.singleton("groovy");
    }
}

