/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.channels;

import io.grpc.netty.NettyChannelBuilder;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.env.Environment;
import io.micronaut.core.naming.Named;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public abstract class GrpcManagedChannelConfiguration
implements Named {
    public static final String PREFIX = "grpc.channels";
    public static final String SETTING_TARGET = ".target";
    public static final String SETTING_URL = ".address";
    protected final String name;
    @ConfigurationBuilder(prefixes={"use", ""}, allowZeroArgs=true)
    protected final NettyChannelBuilder channelBuilder;

    public GrpcManagedChannelConfiguration(String name, Environment env, ExecutorService executorService) {
        this.name = name;
        Optional socketAddress = env.getProperty("grpc.channels." + name + SETTING_URL, SocketAddress.class);
        if (socketAddress.isPresent()) {
            SocketAddress serverAddress = (SocketAddress)socketAddress.get();
            if (serverAddress instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)serverAddress;
                if (isa.isUnresolved()) {
                    isa = new InetSocketAddress(isa.getHostString(), isa.getPort());
                }
                this.channelBuilder = NettyChannelBuilder.forAddress((String)isa.getHostName(), (int)isa.getPort());
            } else {
                this.channelBuilder = NettyChannelBuilder.forAddress((SocketAddress)serverAddress);
            }
        } else {
            Optional target = env.getProperty("grpc.channels." + name + SETTING_TARGET, String.class);
            if (target.isPresent()) {
                this.channelBuilder = NettyChannelBuilder.forTarget((String)((String)target.get()));
            } else {
                URI uri;
                URI uRI = uri = name.contains("//") ? URI.create(name) : null;
                if (uri != null && uri.getHost() != null && uri.getPort() > -1) {
                    this.channelBuilder = NettyChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort());
                    if ("http".equalsIgnoreCase(uri.getScheme())) {
                        this.channelBuilder.usePlaintext();
                    }
                } else {
                    this.channelBuilder = NettyChannelBuilder.forTarget((String)name);
                }
            }
        }
        this.getChannelBuilder().executor((Executor)executorService);
    }

    public String getName() {
        return this.name;
    }

    public NettyChannelBuilder getChannelBuilder() {
        return this.channelBuilder;
    }
}

