/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.channels;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.grpc.annotation.GrpcChannel;
import io.micronaut.inject.ArgumentInjectionPoint;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class GrpcManagedChannelFactory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcManagedChannelFactory.class);
    private final Map<ChannelKey, ManagedChannel> channels = new ConcurrentHashMap<ChannelKey, ManagedChannel>();
    private final ApplicationContext beanContext;

    public GrpcManagedChannelFactory(ApplicationContext beanContext) {
        this.beanContext = beanContext;
    }

    @Bean
    @Primary
    protected ManagedChannel managedChannel(InjectionPoint<Channel> injectionPoint) {
        Argument argument;
        if (injectionPoint instanceof FieldInjectionPoint) {
            argument = ((FieldInjectionPoint)injectionPoint).asArgument();
        } else if (injectionPoint instanceof ArgumentInjectionPoint) {
            argument = ((ArgumentInjectionPoint)injectionPoint).getArgument();
        } else {
            throw new ConfigurationException("Cannot directly create channels use @Inject or constructor injection instead");
        }
        String target = argument.getAnnotationMetadata().stringValue(GrpcChannel.class).orElse(null);
        if (StringUtils.isEmpty((CharSequence)target)) {
            throw new ConfigurationException("No value specified to @GrpcChannel annotation: " + injectionPoint);
        }
        if ("grpc-server".equalsIgnoreCase(target)) {
            return (ManagedChannel)this.beanContext.getBean(ManagedChannel.class, Qualifiers.byName((String)"grpc-server"));
        }
        return this.channels.computeIfAbsent(new ChannelKey(argument, target), channelKey -> {
            NettyChannelBuilder nettyChannelBuilder = (NettyChannelBuilder)this.beanContext.createBean(NettyChannelBuilder.class, new Object[]{target});
            return nettyChannelBuilder.build();
        });
    }

    @Override
    @PreDestroy
    public void close() {
        for (ManagedChannel channel : this.channels.values()) {
            if (channel.isShutdown()) continue;
            try {
                channel.shutdown().awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Error shutting down GRPC channel: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.channels.clear();
    }

    private static final class ChannelKey {
        final Argument<?> identifier;
        final String value;

        public ChannelKey(Argument<?> identifier, String value) {
            this.identifier = identifier;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChannelKey clientKey = (ChannelKey)o;
            return Objects.equals(this.identifier, clientKey.identifier) && Objects.equals(this.value, clientKey.value);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.value);
        }
    }
}

