/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.channels;

import io.grpc.netty.NettyChannelBuilder;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.env.Environment;
import io.micronaut.core.naming.Named;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public abstract class GrpcManagedChannelConfiguration
implements Named {
    public static final String PREFIX = "grpc.channels";
    public static final String SETTING_TARGET = ".target";
    public static final String SETTING_URL = ".address";
    public static final String CONNECT_ON_STARTUP = ".connect-on-startup";
    public static final String CONNECTION_TIMEOUT = ".connection-timeout";
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(20L);
    protected final String name;
    @ConfigurationBuilder(prefixes={"use", ""}, allowZeroArgs=true)
    protected final NettyChannelBuilder channelBuilder;
    private final boolean connectOnStartup;
    private final Duration connectionTimeout;

    protected GrpcManagedChannelConfiguration(String name, Environment env, ExecutorService executorService) {
        this.name = name;
        this.connectOnStartup = env.getProperty("grpc.channels." + name + CONNECT_ON_STARTUP, Boolean.class).isPresent();
        this.connectionTimeout = env.getProperty("grpc.channels." + name + CONNECTION_TIMEOUT, Long.class).filter(t -> t > 0L).map(Duration::ofSeconds).orElse(DEFAULT_CONNECTION_TIMEOUT);
        this.channelBuilder = env.getProperty("grpc.channels." + name + SETTING_URL, SocketAddress.class).map(this::getChannelBuilder).orElseGet(() -> env.getProperty("grpc.channels." + name + SETTING_TARGET, String.class).map(NettyChannelBuilder::forTarget).orElseGet(() -> {
            URI uri;
            URI uRI = uri = name.contains("//") ? URI.create(name) : null;
            if (uri != null && uri.getHost() != null && uri.getPort() > -1) {
                NettyChannelBuilder nettyChannelBuilder = NettyChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort());
                if ("http".equalsIgnoreCase(uri.getScheme())) {
                    nettyChannelBuilder.usePlaintext();
                }
                return nettyChannelBuilder;
            }
            return NettyChannelBuilder.forTarget((String)name);
        }));
        this.getChannelBuilder().executor((Executor)executorService);
    }

    private NettyChannelBuilder getChannelBuilder(SocketAddress serverAddress) {
        if (serverAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)serverAddress;
            if (isa.isUnresolved()) {
                isa = new InetSocketAddress(isa.getHostString(), isa.getPort());
            }
            return NettyChannelBuilder.forAddress((String)isa.getHostName(), (int)isa.getPort());
        }
        return NettyChannelBuilder.forAddress((SocketAddress)serverAddress);
    }

    public String getName() {
        return this.name;
    }

    public boolean isConnectOnStartup() {
        return this.connectOnStartup;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public NettyChannelBuilder getChannelBuilder() {
        return this.channelBuilder;
    }
}

