/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.channels;

import io.grpc.ClientInterceptor;
import io.grpc.netty.NettyChannelBuilder;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.grpc.channels.GrpcDefaultManagedChannelConfiguration;
import io.micronaut.grpc.channels.GrpcManagedChannelConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;

@Factory
public class GrpcChannelBuilderFactory {
    private final ApplicationContext beanContext;
    private final ExecutorService executorService;

    public GrpcChannelBuilderFactory(ApplicationContext beanContext, @Named(value="io") ExecutorService executorService) {
        this.beanContext = beanContext;
        this.executorService = executorService;
    }

    @Bean
    @Prototype
    protected NettyChannelBuilder managedChannelBuilder(@Parameter String target, List<ClientInterceptor> interceptors) {
        GrpcManagedChannelConfiguration config = this.beanContext.findBean(GrpcManagedChannelConfiguration.class, Qualifiers.byName((String)target)).orElseGet(() -> {
            GrpcDefaultManagedChannelConfiguration mcc = new GrpcDefaultManagedChannelConfiguration(target, this.beanContext.getEnvironment(), this.executorService);
            this.beanContext.inject((Object)mcc);
            return mcc;
        });
        NettyChannelBuilder channelBuilder = config.getChannelBuilder();
        if (CollectionUtils.isNotEmpty(interceptors)) {
            Collections.reverse(interceptors);
            channelBuilder.intercept(interceptors);
        }
        return channelBuilder;
    }
}

