/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.discovery;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import io.grpc.Status;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceList;
import io.micronaut.discovery.exceptions.NoAvailableServiceException;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

@Singleton
@Requirements(value={@Requires(beans={DiscoveryClient.class}), @Requires(property="grpc.client.discovery.enabled", value="true", defaultValue="false")})
public class GrpcNameResolverProvider
extends NameResolverProvider
implements LifeCycle<GrpcNameResolverProvider> {
    public static final String ENABLED = "grpc.client.discovery.enabled";
    public static final int PRIORITY = 7;
    private static final String SCHEME = "svc";
    private final DiscoveryClient discoveryClient;
    private final List<ServiceInstanceList> serviceInstanceLists;
    private boolean operational;

    protected GrpcNameResolverProvider(DiscoveryClient discoveryClient, List<ServiceInstanceList> serviceInstanceLists) {
        this.discoveryClient = discoveryClient;
        this.serviceInstanceLists = serviceInstanceLists;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 7;
    }

    public NameResolver newNameResolver(final URI targetUri, NameResolver.Args args) {
        String resolvedServiceId;
        final String serviceId = targetUri.toString();
        String string = resolvedServiceId = serviceId.startsWith("svc:///") ? serviceId.substring(7) : serviceId;
        if (resolvedServiceId.contains(":")) {
            return new NameResolver(){

                public void start(NameResolver.Listener listener) {
                    String[] hostAndPort = resolvedServiceId.split(":");
                    List<EquivalentAddressGroup> equivalentAddressGroups = Collections.singletonList(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]))));
                    listener.onAddresses(equivalentAddressGroups, Attributes.EMPTY);
                }

                public String getServiceAuthority() {
                    return resolvedServiceId;
                }

                public void shutdown() {
                }
            };
        }
        if (!NameUtils.isHyphenatedLowerCase((String)resolvedServiceId)) {
            throw new IllegalArgumentException("Invalid service ID [" + resolvedServiceId + "]. Service IDs should be kebab-case (lowercase / hyphen separated). For example 'greeting-service'.");
        }
        return new NameResolver(){
            private volatile NameResolver.Listener listener;
            private Disposable disposable;

            public String getServiceAuthority() {
                return "//" + resolvedServiceId;
            }

            public void refresh() {
                for (ServiceInstanceList serviceInstanceList : GrpcNameResolverProvider.this.serviceInstanceLists) {
                    if (!serviceInstanceList.getID().equals(resolvedServiceId)) continue;
                    this.listener.onAddresses(this.toAddresses(serviceInstanceList.getInstances()), Attributes.EMPTY);
                    return;
                }
                this.disposable = Flux.from((Publisher)GrpcNameResolverProvider.this.discoveryClient.getInstances(resolvedServiceId)).subscribe(instances -> {
                    if (CollectionUtils.isNotEmpty((Collection)instances)) {
                        List<EquivalentAddressGroup> servers = this.toAddresses((List<ServiceInstance>)instances);
                        this.listener.onAddresses(servers, Attributes.EMPTY);
                    } else if (targetUri.getHost() != null && targetUri.getPort() > -1) {
                        this.listener.onAddresses(Collections.singletonList(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(targetUri.getHost(), targetUri.getPort()))), Attributes.EMPTY);
                    } else {
                        this.listener.onError(Status.UNAVAILABLE.withCause((Throwable)new NoAvailableServiceException(serviceId)));
                    }
                }, error -> this.listener.onError(Status.fromThrowable((Throwable)error)));
            }

            public void start(NameResolver.Listener listener) {
                this.listener = listener;
                this.refresh();
            }

            private List<EquivalentAddressGroup> toAddresses(List<ServiceInstance> instances) {
                return instances.stream().map(serviceInstance -> new InetSocketAddress(serviceInstance.getHost(), serviceInstance.getPort())).map(EquivalentAddressGroup::new).toList();
            }

            public void shutdown() {
                if (this.disposable != null && !this.disposable.isDisposed()) {
                    this.disposable.dispose();
                }
            }
        };
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    public boolean isRunning() {
        return this.operational;
    }

    @NonNull
    @PostConstruct
    public GrpcNameResolverProvider start() {
        NameResolverRegistry.getDefaultRegistry().register((NameResolverProvider)this);
        this.operational = true;
        return this;
    }

    @NonNull
    @PreDestroy
    public GrpcNameResolverProvider stop() {
        NameResolverRegistry.getDefaultRegistry().deregister((NameResolverProvider)this);
        this.operational = false;
        return this;
    }

    @Singleton
    @Internal
    static final class ManagedChannelBuilderListener
    implements BeanCreatedEventListener<ManagedChannelBuilder<?>> {
        private BeanProvider<GrpcNameResolverProvider> beanProvider;

        ManagedChannelBuilderListener(@Nullable BeanProvider<GrpcNameResolverProvider> beanProvider) {
            this.beanProvider = beanProvider;
        }

        public ManagedChannelBuilder<?> onCreated(BeanCreatedEvent<ManagedChannelBuilder<?>> event) {
            if (this.beanProvider != null) {
                this.beanProvider.get();
                this.beanProvider = null;
            }
            return (ManagedChannelBuilder)event.getBean();
        }
    }
}

