/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.client.tracing;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.ClientCloseDecorator;
import io.opentracing.contrib.grpc.ClientSpanDecorator;
import io.opentracing.contrib.grpc.TracingClientInterceptor;
import jakarta.inject.Inject;

@ConfigurationProperties(value="grpc.client.tracing")
public class GrpcClientTracingInterceptorConfiguration {
    public static final String PREFIX = "grpc.client.tracing";
    @ConfigurationBuilder(prefixes={"with"}, allowZeroArgs=true)
    protected final TracingClientInterceptor.Builder builder;

    protected GrpcClientTracingInterceptorConfiguration(Tracer tracer) {
        this.builder = TracingClientInterceptor.newBuilder().withTracer(tracer);
    }

    @NonNull
    public TracingClientInterceptor.Builder getBuilder() {
        return this.builder;
    }

    @Inject
    public void setClientSpanDecorator(@Nullable ClientSpanDecorator clientSpanDecorator) {
        if (clientSpanDecorator != null) {
            this.builder.withClientSpanDecorator(clientSpanDecorator);
        }
    }

    @Inject
    public void setClientCloseDecorator(@Nullable ClientCloseDecorator clientCloseDecorator) {
        if (clientCloseDecorator != null) {
            this.builder.withClientCloseDecorator(clientCloseDecorator);
        }
    }
}

