/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.server;

import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.grpc.server.GrpcServerConfiguration;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Factory
public class GrpcServerBuilder {
    @Bean
    @Singleton
    protected ServerBuilder<?> serverBuilder(GrpcServerConfiguration configuration, @Nullable List<BindableService> serviceList, @Nullable List<ServerInterceptor> interceptors, @Nullable List<ServerTransportFilter> serverTransportFilters) {
        ServerBuilder<?> serverBuilder = configuration.getServerBuilder();
        if (CollectionUtils.isNotEmpty(serviceList)) {
            for (BindableService bindableService : serviceList) {
                serverBuilder.addService(bindableService);
            }
        }
        if (CollectionUtils.isNotEmpty(interceptors)) {
            OrderUtil.reverseSort(interceptors);
            for (ServerInterceptor serverInterceptor : interceptors) {
                serverBuilder.intercept(serverInterceptor);
            }
        }
        if (CollectionUtils.isNotEmpty(serverTransportFilters)) {
            for (ServerTransportFilter serverTransportFilter : serverTransportFilters) {
                serverBuilder.addTransportFilter(serverTransportFilter);
            }
        }
        return serverBuilder;
    }
}

