/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.server;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.grpc.server.GrpcEmbeddedServer;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;

@Factory
public class GrpcServerChannel {
    public static final String NAME = "grpc-server";

    @Singleton
    @Named(value="grpc-server")
    @Requires(beans={GrpcEmbeddedServer.class})
    @Bean(preDestroy="shutdown")
    protected ManagedChannel serverChannel(GrpcEmbeddedServer server, @Named(value="io") ExecutorService executorService, List<ClientInterceptor> clientInterceptors) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)server.getHost(), (int)server.getPort()).executor((Executor)executorService);
        if (!server.getServerConfiguration().isSecure()) {
            builder.usePlaintext();
        }
        if (CollectionUtils.isNotEmpty(clientInterceptors)) {
            builder.intercept(clientInterceptors);
        }
        return builder.build();
    }
}

