/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.server;

import com.google.common.base.Preconditions;
import io.grpc.ServerBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.env.Environment;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.convert.format.ReadableBytes;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.grpc.server.GrpcSslConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@ConfigurationProperties(value="grpc.server")
public class GrpcServerConfiguration {
    public static final String PREFIX = "grpc.server";
    public static final String PORT = "grpc.server.port";
    public static final String HOST = "grpc.server.host";
    public static final String ENABLED = "grpc.server.enabled";
    public static final String HEALTH_ENABLED = "grpc.server.health.enabled";
    public static final int DEFAULT_PORT = 50051;
    public static final Duration DEFAULT_AWAIT_TERMINATION = Duration.ofSeconds(30L);
    @ConfigurationBuilder(prefixes={""}, excludes={"protocolNegotiator"})
    protected final NettyServerBuilder serverBuilder;
    private final int serverPort;
    private final String serverHost;
    private final ResourceResolver resourceResolver;
    private GrpcSslConfiguration serverConfiguration = new GrpcSslConfiguration();
    private boolean secure = false;
    private String instanceId = "";
    private Duration awaitTermination = DEFAULT_AWAIT_TERMINATION;

    @Deprecated
    public GrpcServerConfiguration(Environment environment, @Property(name="grpc.server.host") @Nullable String serverHost, @Property(name="grpc.server.port") @Nullable Integer serverPort, @Named(value="io") ExecutorService executorService) {
        this(environment, serverHost, serverPort, executorService, null);
    }

    @Creator
    public GrpcServerConfiguration(Environment environment, @Property(name="grpc.server.host") @Nullable String serverHost, @Property(name="grpc.server.port") @Nullable Integer serverPort, @Named(value="io") ExecutorService executorService, ResourceResolver resourceResolver) {
        this.serverPort = serverPort != null ? serverPort : (environment.getActiveNames().contains("test") ? SocketUtils.findAvailableTcpPort() : 50051);
        this.serverHost = serverHost;
        this.serverBuilder = serverHost != null ? NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(serverHost, this.serverPort)) : NettyServerBuilder.forPort((int)this.serverPort);
        this.serverBuilder.executor((Executor)executorService);
        this.resourceResolver = resourceResolver;
    }

    public boolean isSecure() {
        return this.secure;
    }

    @Nonnull
    public ServerBuilder<?> getServerBuilder() {
        return this.serverBuilder;
    }

    public Optional<String> getServerHost() {
        return Optional.ofNullable(this.serverHost);
    }

    public int getServerPort() {
        return this.serverPort;
    }

    @Nonnull
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setMaxInboundMessageSize(@ReadableBytes int bytes) {
        Preconditions.checkArgument((bytes >= 0 ? 1 : 0) != 0, (Object)"bytes must be >= 0");
        this.serverBuilder.maxInboundMessageSize(bytes);
    }

    public void setMaxInboundMetadataSize(@ReadableBytes int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMetadataSize must be > 0");
        this.serverBuilder.maxInboundMetadataSize(bytes);
    }

    @Nonnull
    public GrpcSslConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public void setAwaitTermination(Duration awaitTermination) {
        this.awaitTermination = awaitTermination;
    }

    public Duration getAwaitTermination() {
        return this.awaitTermination;
    }

    @Inject
    public void setServerConfiguration(GrpcSslConfiguration sslConfiguration) {
        if (sslConfiguration != null) {
            this.serverConfiguration = sslConfiguration;
            if (this.resourceResolver != null) {
                Optional certChain = sslConfiguration.getCertChain().flatMap(arg_0 -> ((ResourceResolver)this.resourceResolver).getResourceAsStream(arg_0));
                Optional privateKey = sslConfiguration.getPrivateKey().flatMap(arg_0 -> ((ResourceResolver)this.resourceResolver).getResourceAsStream(arg_0));
                boolean hasCert = certChain.isPresent();
                boolean hasPrivateKey = privateKey.isPresent();
                if (hasCert && hasPrivateKey) {
                    try {
                        try (InputStream certStream = (InputStream)certChain.get();
                             InputStream keyStream = (InputStream)privateKey.get();){
                            this.serverBuilder.useTransportSecurity(certStream, keyStream);
                        }
                        this.secure = true;
                    }
                    catch (IOException e) {
                        throw new ConfigurationException("Unable to configure SSL certificate: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (hasCert) {
                    try {
                        ((InputStream)certChain.get()).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new ConfigurationException("Both 'cert-chain' and 'private-key' properties should be configured");
                }
                if (hasPrivateKey) {
                    try {
                        ((InputStream)privateKey.get()).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new ConfigurationException("Both 'cert-chain' and 'private-key' properties should be configured");
                }
            }
        }
    }
}

