/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.server;

import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.metadata.ServiceInstanceMetadataContributor;
import io.micronaut.grpc.server.GrpcServerConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class GrpcServerInstance
implements EmbeddedServerInstance {
    private final String id;
    private final URI uri;
    private final ConvertibleValues<String> metadata;
    private final EmbeddedServer embeddedServer;

    @Deprecated
    GrpcServerInstance(EmbeddedServer embeddedServer, String id, URI uri, @Nullable Map<String, String> metadata, @Nullable List<ServiceInstanceMetadataContributor> metadataContributors) {
        this(embeddedServer, id, uri, metadata, metadataContributors, null);
    }

    GrpcServerInstance(EmbeddedServer embeddedServer, String id, URI uri, @Nullable Map<String, String> metadata, @Nullable List<ServiceInstanceMetadataContributor> metadataContributors, GrpcServerConfiguration grpcConfiguration) {
        this.embeddedServer = embeddedServer;
        this.id = this.calculateInstanceId(id, grpcConfiguration);
        this.uri = uri;
        if (metadata == null) {
            metadata = new LinkedHashMap<String, String>(5);
        }
        if (CollectionUtils.isNotEmpty(metadataContributors)) {
            for (ServiceInstanceMetadataContributor contributor : metadataContributors) {
                contributor.contribute((ServiceInstance)this, metadata);
            }
        }
        this.metadata = ConvertibleValues.of(metadata);
    }

    public String getId() {
        return this.id;
    }

    public URI getURI() {
        return this.uri;
    }

    public ConvertibleValues<String> getMetadata() {
        return this.metadata;
    }

    public EmbeddedServer getEmbeddedServer() {
        return this.embeddedServer;
    }

    private String calculateInstanceId(String id, @Nullable GrpcServerConfiguration grpcConfiguration) {
        if (grpcConfiguration != null && StringUtils.isNotEmpty((CharSequence)grpcConfiguration.getInstanceId())) {
            return grpcConfiguration.getInstanceId();
        }
        return id;
    }
}

