/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.server.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.AsyncSingleResultPublisher;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.grpc.server.GrpcEmbeddedServer;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import java.util.Map;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requirements(value={@Requires(property="grpc.server.health.enabled", value="true", defaultValue="true"), @Requires(beans={HealthEndpoint.class}), @Requires(beans={GrpcEmbeddedServer.class})})
public class GrpcServerHealthIndicator
implements HealthIndicator {
    private static final String ID = "grpc-server";
    private final GrpcEmbeddedServer server;

    public GrpcServerHealthIndicator(GrpcEmbeddedServer server) {
        this.server = server;
    }

    public Publisher<HealthResult> getResult() {
        return new AsyncSingleResultPublisher(this::getHealthResult);
    }

    private HealthResult getHealthResult() {
        HealthStatus healthStatus = this.server.isRunning() ? HealthStatus.UP : HealthStatus.DOWN;
        String serverHost = this.server.getHost();
        int serverPort = this.server.getServerConfiguration().getServerPort();
        Map details = CollectionUtils.mapOf((Object[])new Object[]{"host", serverHost, "port", serverPort});
        return HealthResult.builder((String)ID, (HealthStatus)healthStatus).details((Object)details).build();
    }
}

