/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.server.tracing;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.ServerCloseDecorator;
import io.opentracing.contrib.grpc.ServerSpanDecorator;
import io.opentracing.contrib.grpc.TracingServerInterceptor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

@ConfigurationProperties(value="grpc.server.tracing")
public class GrpcServerTracingInterceptorConfiguration {
    public static final String PREFIX = "grpc.server.tracing";
    @ConfigurationBuilder(prefixes={"with"}, allowZeroArgs=true)
    protected final TracingServerInterceptor.Builder builder;

    protected GrpcServerTracingInterceptorConfiguration(Tracer tracer) {
        this.builder = TracingServerInterceptor.newBuilder().withTracer(tracer);
    }

    @Nonnull
    public TracingServerInterceptor.Builder getBuilder() {
        return this.builder;
    }

    @Inject
    public void setServerSpanDecorator(@Nullable ServerSpanDecorator serverSpanDecorator) {
        if (serverSpanDecorator != null) {
            this.builder.withServerSpanDecorator(serverSpanDecorator);
        }
    }

    @Inject
    public void setServerCloseDecorator(@Nullable ServerCloseDecorator serverCloseDecorator) {
        if (serverCloseDecorator != null) {
            this.builder.withServerCloseDecorator(serverCloseDecorator);
        }
    }
}

