/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.server;

import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerTransportFilter;
import io.grpc.protobuf.services.HealthStatusManager;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.grpc.server.GrpcServerConfiguration;
import io.micronaut.grpc.server.health.HealthStatusManagerContainer;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class GrpcServerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcServerBuilder.class);
    @Nullable
    private final HealthStatusManagerContainer healthStatusManagerContainer;

    @Inject
    public GrpcServerBuilder(@Nullable HealthStatusManagerContainer healthStatusManagerContainer) {
        this.healthStatusManagerContainer = healthStatusManagerContainer;
    }

    @Bean
    @Singleton
    protected ServerBuilder<?> serverBuilder(GrpcServerConfiguration configuration, @Nullable List<BindableService> serviceList, @Nullable List<ServerInterceptor> interceptors, @Nullable List<ServerTransportFilter> serverTransportFilters, @Nullable List<ServerServiceDefinition> serverServiceDefinitions) {
        ServerBuilder<?> serverBuilder = configuration.getServerBuilder();
        if (this.healthStatusManagerContainer != null) {
            HealthStatusManager healthStatusManager = this.healthStatusManagerContainer.getHealthStatusManager();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding health status manager {}", (Object)healthStatusManager);
            }
            serverBuilder.addService(healthStatusManager.getHealthService());
        }
        if (CollectionUtils.isNotEmpty(serviceList)) {
            for (BindableService bindableService : serviceList) {
                serverBuilder.addService(bindableService);
            }
        }
        if (CollectionUtils.isNotEmpty(interceptors)) {
            OrderUtil.reverseSort(interceptors);
            for (ServerInterceptor serverInterceptor : interceptors) {
                serverBuilder.intercept(serverInterceptor);
            }
        }
        if (CollectionUtils.isNotEmpty(serverTransportFilters)) {
            for (ServerTransportFilter serverTransportFilter : serverTransportFilters) {
                serverBuilder.addTransportFilter(serverTransportFilter);
            }
        }
        if (CollectionUtils.isNotEmpty(serverServiceDefinitions)) {
            serverBuilder.addServices(serverServiceDefinitions);
        }
        return serverBuilder;
    }
}

