/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.protobuf.codec;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class ProtobufferCodec
implements MediaTypeCodec {
    public static final String X_PROTOBUF_MESSAGE_HEADER = "X-Protobuf-Message";
    public static final String PROTOBUFFER_ENCODED = "application/x-protobuf";
    public static final String PROTOBUFFER_ENCODED2 = "application/protobuf";
    public static final MediaType PROTOBUFFER_ENCODED_TYPE = new MediaType("application/x-protobuf");
    public static final MediaType PROTOBUFFER_ENCODED_TYPE2 = new MediaType("application/protobuf");
    public static final List<MediaType> DEFAULT_MEDIA_TYPES = Arrays.asList(PROTOBUFFER_ENCODED_TYPE, PROTOBUFFER_ENCODED_TYPE2);
    private final ConcurrentHashMap<Class<?>, Method> methodCache = new ConcurrentHashMap();
    private final ExtensionRegistry extensionRegistry;
    private List<MediaType> mediaTypes = DEFAULT_MEDIA_TYPES;

    public ProtobufferCodec(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    public boolean supportsType(Class<?> type) {
        return Message.class.isAssignableFrom(type);
    }

    public Collection<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaType> mediaTypes) {
        this.mediaTypes = Collections.unmodifiableList(new ArrayList<MediaType>(mediaTypes));
    }

    public <T> T decode(Argument<T> type, InputStream inputStream) throws CodecException {
        try {
            Message.Builder builder = this.getBuilder(type).orElseThrow(() -> new CodecException("Unable to create builder"));
            if (type.hasTypeVariables()) {
                throw new IllegalStateException("Generic type arguments are not supported");
            }
            builder.mergeFrom(inputStream, (ExtensionRegistryLite)this.extensionRegistry);
            return type.getType().cast(builder.build());
        }
        catch (Exception e) {
            throw new CodecException("Error decoding Protobuff stream for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, ByteBuffer<?> buffer) throws CodecException {
        try {
            if (type.getType() == byte[].class) {
                return (T)buffer.toByteArray();
            }
            Message.Builder builder = this.getBuilder(type).orElseThrow(() -> new CodecException("Unable to create builder"));
            if (type.hasTypeVariables()) {
                throw new IllegalStateException("Generic type arguments are not supported");
            }
            builder.mergeFrom(buffer.toByteArray(), (ExtensionRegistryLite)this.extensionRegistry);
            return type.getType().cast(builder.build());
        }
        catch (Exception e) {
            throw new CodecException("Error decoding Protobuff bytes for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public <T> T decode(Argument<T> type, byte[] bytes) throws CodecException {
        try {
            if (type.getType() == byte[].class) {
                return (T)bytes;
            }
            Message.Builder builder = this.getBuilder(type).orElseThrow(() -> new CodecException("Unable to create builder"));
            if (type.hasTypeVariables()) {
                throw new IllegalStateException("Generic type arguments are not supported");
            }
            builder.mergeFrom(bytes, (ExtensionRegistryLite)this.extensionRegistry);
            return type.getType().cast(builder.build());
        }
        catch (Exception e) {
            throw new CodecException("Error decoding Protobuff bytes for type [" + type.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private <T> Optional<Message.Builder> getBuilder(Argument<T> type) {
        Class clazz = type.getType();
        return this.getMessageBuilder(clazz);
    }

    public <T> void encode(T object, OutputStream outputStream) throws CodecException {
        try {
            if (object instanceof Message) {
                ((Message)object).writeTo(outputStream);
            }
        }
        catch (IOException e) {
            throw new CodecException("Error encoding object [" + object + "] to OutputStream:" + e.getMessage());
        }
    }

    public <T> byte[] encode(T object) throws CodecException {
        if (object instanceof Message) {
            return ((Message)object).toByteArray();
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return new byte[0];
    }

    public <T, B> ByteBuffer<B> encode(T object, ByteBufferFactory<?, B> allocator) throws CodecException {
        return allocator.copiedBuffer(this.encode(object));
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public Optional<Message.Builder> getMessageBuilder(Class<? extends Message> clazz) {
        try {
            return this.createBuilder(clazz);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    private Optional<Message.Builder> createBuilder(Class<? extends Message> clazz) throws Exception {
        return Optional.of((Message.Builder)this.getMethod(clazz).invoke(clazz, new Object[0]));
    }

    private Method getMethod(Class<? extends Message> clazz) throws NoSuchMethodException {
        Method method = this.methodCache.get(clazz);
        if (method == null) {
            method = clazz.getMethod("newBuilder", new Class[0]);
            this.methodCache.put(clazz, method);
        }
        return method;
    }
}

