/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.protobuf.convert;

import com.google.protobuf.Message;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.netty.buffer.ByteBuf;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
@Requires(classes={Message.class, ByteBuf.class})
public class ProtoMessageToByteBufConverter
implements TypeConverter<Message, ByteBuf> {
    private final ConversionService<?> conversionService;

    public ProtoMessageToByteBufConverter(ConversionService<?> conversionService) {
        this.conversionService = conversionService;
    }

    public Optional<ByteBuf> convert(Message object, Class<ByteBuf> targetType, ConversionContext context) {
        return this.conversionService.convert((Object)object.toByteArray(), targetType, context);
    }
}

