/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.protobuf.handler;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.codec.CodecException;
import io.micronaut.protobuf.codec.ProtobufferCodec;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;

@Singleton
@Produces(value={"application/x-protobuf", "application/protobuf"})
@Consumes(value={"application/x-protobuf", "application/protobuf"})
public final class ProtobufBodyHandler<T extends Message>
implements MessageBodyHandler<T> {
    private final ProtobufferCodec codec;
    private final ExtensionRegistry extensionRegistry;

    public ProtobufBodyHandler(ProtobufferCodec codec, ExtensionRegistry extensionRegistry) {
        this.codec = codec;
        this.extensionRegistry = extensionRegistry;
    }

    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        Message.Builder builder = this.getBuilder(type).orElseThrow(() -> new CodecException("Unable to create builder"));
        if (type.hasTypeVariables()) {
            throw new IllegalStateException("Generic type arguments are not supported");
        }
        try {
            builder.mergeFrom(inputStream, (ExtensionRegistryLite)this.extensionRegistry);
        }
        catch (IOException e) {
            throw new CodecException("Failed to read protobuf", (Throwable)e);
        }
        return (T)((Message)type.getType().cast(builder.build()));
    }

    public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        outgoingHeaders.set((CharSequence)"Content-Type", (CharSequence)(mediaType != null ? mediaType : ProtobufferCodec.PROTOBUFFER_ENCODED_TYPE));
        try {
            object.writeTo(outputStream);
        }
        catch (IOException e) {
            throw new CodecException("Failed to write protobuf", (Throwable)e);
        }
    }

    private Optional<Message.Builder> getBuilder(Argument<T> type) {
        return this.codec.getMessageBuilder(type.getType());
    }
}

