/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.protobuf.convert;

import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.protobuf.codec.ProtobufferCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

@Singleton
@Requires(classes={Message.class, ByteBuf.class})
public class ByteBufToProtoMessageConverter
implements TypeConverter<ByteBuf, Message> {
    private final ProtobufferCodec codec;

    public ByteBufToProtoMessageConverter(ProtobufferCodec codec) {
        this.codec = codec;
    }

    public Optional<Message> convert(ByteBuf object, Class<Message> targetType, ConversionContext context) {
        return this.codec.getMessageBuilder(targetType).flatMap(builder -> this.rehydrate(object, (Message.Builder)builder, context));
    }

    private Optional<Message> rehydrate(ByteBuf object, Message.Builder builder, ConversionContext context) {
        Optional<Message> optional;
        ByteBufInputStream byteBufInputStream = new ByteBufInputStream(object.copy(), true);
        try {
            builder.mergeFrom((InputStream)byteBufInputStream, (ExtensionRegistryLite)this.codec.getExtensionRegistry());
            optional = Optional.of(builder.build());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteBufInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        }
        byteBufInputStream.close();
        return optional;
    }
}

