/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.ServiceInstanceList;
import io.micronaut.discovery.StaticServiceInstanceList;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.DefaultHttpClient;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.ServiceHttpClientCondition;
import io.micronaut.http.client.ServiceHttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.loadbalance.ServiceInstanceListLoadBalancerFactory;
import io.micronaut.scheduling.TaskScheduler;
import io.reactivex.Flowable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;

@Factory
public class ServiceHttpClientFactory {
    private final BeanContext beanContext;
    private final ServiceInstanceListLoadBalancerFactory loadBalancerFactory;
    private final TaskScheduler taskScheduler;

    public ServiceHttpClientFactory(BeanContext beanContext, ServiceInstanceListLoadBalancerFactory loadBalancerFactory, TaskScheduler taskScheduler) {
        this.beanContext = beanContext;
        this.loadBalancerFactory = loadBalancerFactory;
        this.taskScheduler = taskScheduler;
    }

    @EachBean(value=ServiceHttpClientConfiguration.class)
    @Requires(condition=ServiceHttpClientCondition.class)
    ServiceInstanceList serviceInstanceList(ServiceHttpClientConfiguration configuration) {
        List<URI> originalURLs = configuration.getUrls();
        ConcurrentLinkedQueue<URI> loadBalancedURIs = new ConcurrentLinkedQueue<URI>(originalURLs);
        return new StaticServiceInstanceList(configuration.getServiceId(), loadBalancedURIs);
    }

    @EachBean(value=ServiceHttpClientConfiguration.class)
    @Requires(condition=ServiceHttpClientCondition.class)
    DefaultHttpClient serviceHttpClient(@Parameter ServiceHttpClientConfiguration configuration, @Parameter ServiceInstanceList instanceList) {
        List<URI> originalURLs = configuration.getUrls();
        ConcurrentLinkedQueue<URI> loadBalancedURIs = new ConcurrentLinkedQueue<URI>(originalURLs);
        boolean isHealthCheck = configuration.isHealthCheck();
        LoadBalancer loadBalancer = this.loadBalancerFactory.create(instanceList);
        Optional<String> path = configuration.getPath();
        DefaultHttpClient httpClient = path.isPresent() ? (DefaultHttpClient)this.beanContext.createBean(DefaultHttpClient.class, new Object[]{loadBalancer, configuration, path.get()}) : (DefaultHttpClient)this.beanContext.createBean(DefaultHttpClient.class, new Object[]{loadBalancer, configuration});
        if (isHealthCheck) {
            this.taskScheduler.scheduleWithFixedDelay(configuration.getHealthCheckInterval(), configuration.getHealthCheckInterval(), () -> Flowable.fromIterable((Iterable)originalURLs).flatMap(originalURI -> {
                URI healthCheckURI = originalURI.resolve(configuration.getHealthCheckUri());
                return httpClient.exchange((HttpRequest)HttpRequest.GET((URI)healthCheckURI)).onErrorResumeNext(throwable -> {
                    if (throwable instanceof HttpClientResponseException) {
                        HttpClientResponseException responseException = (HttpClientResponseException)((Object)((Object)((Object)((Object)throwable))));
                        HttpResponse<?> response = responseException.getResponse();
                        return Flowable.just(response);
                    }
                    return Flowable.just((Object)HttpResponse.serverError());
                }).map(response -> Collections.singletonMap(originalURI, response.getStatus()));
            }).subscribe(uriToStatusMap -> {
                Map.Entry entry = uriToStatusMap.entrySet().iterator().next();
                URI uri = (URI)entry.getKey();
                HttpStatus status = (HttpStatus)entry.getValue();
                if (status.getCode() >= 300) {
                    loadBalancedURIs.remove(uri);
                } else if (!loadBalancedURIs.contains(uri)) {
                    loadBalancedURIs.add(uri);
                }
            }));
        }
        return httpClient;
    }
}

