/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.exceptions;

import io.micronaut.core.naming.Described;
import io.micronaut.http.MediaType;
import io.micronaut.http.hateos.JsonError;
import io.micronaut.http.hateos.VndError;
import java.util.Optional;

public interface HttpClientErrorDecoder {
    public static final HttpClientErrorDecoder DEFAULT = new HttpClientErrorDecoder(){};

    default public Optional<String> getMessage(Object error) {
        if (error == null) {
            return Optional.empty();
        }
        if (error instanceof JsonError) {
            return Optional.ofNullable(((JsonError)error).getMessage());
        }
        if (error instanceof Described) {
            return Optional.ofNullable(((Described)error).getDescription());
        }
        return Optional.of(error.toString());
    }

    default public Class<?> getErrorType(MediaType mediaType) {
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            return JsonError.class;
        }
        if (mediaType.equals((Object)MediaType.APPLICATION_VND_ERROR_TYPE)) {
            return VndError.class;
        }
        return String.class;
    }
}

