/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.exceptions;

import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.client.exceptions.HttpClientErrorDecoder;
import io.micronaut.http.client.exceptions.HttpClientException;
import java.util.Optional;

public class HttpClientResponseException
extends HttpClientException {
    private final HttpResponse<?> response;
    private final HttpClientErrorDecoder errorDecoder;

    public HttpClientResponseException(String message, HttpResponse<?> response) {
        this(message, null, response);
    }

    public HttpClientResponseException(String message, Throwable cause, HttpResponse<?> response) {
        this(message, cause, response, HttpClientErrorDecoder.DEFAULT);
    }

    public HttpClientResponseException(String message, Throwable cause, HttpResponse<?> response, HttpClientErrorDecoder errorDecoder) {
        super(message, cause);
        this.errorDecoder = errorDecoder;
        this.response = response;
        this.initResponse(response);
    }

    public String getMessage() {
        Optional<Class<?>> errorType = Optional.ofNullable(this.getErrorType(this.response));
        if (errorType.isPresent()) {
            return this.getResponse().getBody(errorType.get()).flatMap(this.errorDecoder::getMessage).orElse(super.getMessage());
        }
        return super.getMessage();
    }

    public HttpResponse<?> getResponse() {
        return this.response;
    }

    public HttpStatus getStatus() {
        return this.getResponse().getStatus();
    }

    private void initResponse(HttpResponse<?> response) {
        Class<?> errorType = this.getErrorType(response);
        if (errorType != null) {
            response.getBody(errorType);
        } else {
            response.getBody(String.class);
        }
    }

    private Class<?> getErrorType(HttpResponse<?> response) {
        Optional contentType = response.getContentType();
        Class<?> errorType = null;
        if (contentType.isPresent() && response.getStatus().getCode() > 399) {
            MediaType mediaType = (MediaType)contentType.get();
            errorType = this.errorDecoder.getErrorType(mediaType);
        }
        return errorType;
    }
}

