/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.interceptor;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.LoadBalancerResolver;
import io.micronaut.http.client.ReactiveClientResultTransformer;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.loadbalance.FixedLoadBalancer;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.hateos.JsonError;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.sse.Event;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jackson.ObjectMapperFactory;
import io.micronaut.jackson.annotation.JacksonFeatures;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import io.reactivex.Flowable;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
public class HttpClientIntroductionAdvice
implements MethodInterceptor<Object, Object>,
Closeable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final MediaType[] DEFAULT_ACCEPT_TYPES = new MediaType[]{MediaType.APPLICATION_JSON_TYPE};
    private final int HEADERS_INITIAL_CAPACITY = 3;
    private final BeanContext beanContext;
    private final Map<String, HttpClient> clients = new ConcurrentHashMap<String, HttpClient>();
    private final List<ReactiveClientResultTransformer> transformers;
    private final LoadBalancerResolver loadBalancerResolver;
    private final JsonMediaTypeCodec jsonMediaTypeCodec;

    public HttpClientIntroductionAdvice(BeanContext beanContext, JsonMediaTypeCodec jsonMediaTypeCodec, LoadBalancerResolver loadBalancerResolver, ReactiveClientResultTransformer ... transformers) {
        this(beanContext, jsonMediaTypeCodec, loadBalancerResolver, Arrays.asList(transformers));
    }

    @Inject
    public HttpClientIntroductionAdvice(BeanContext beanContext, JsonMediaTypeCodec jsonMediaTypeCodec, LoadBalancerResolver loadBalancerResolver, List<ReactiveClientResultTransformer> transformers) {
        this.jsonMediaTypeCodec = jsonMediaTypeCodec;
        this.beanContext = beanContext;
        this.loadBalancerResolver = loadBalancerResolver;
        this.transformers = transformers != null ? transformers : Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        AnnotationValue clientAnnotation = (AnnotationValue)context.findAnnotation(Client.class).orElseThrow(() -> new IllegalStateException("Client advice called from type that is not annotated with @Client: " + context));
        HttpClient httpClient = this.getClient(context, (AnnotationValue<Client>)clientAnnotation);
        Class declaringType = context.getDeclaringType();
        if (Closeable.class == declaringType || AutoCloseable.class == declaringType) {
            String clientId = clientAnnotation.getValue(String.class).orElse(null);
            String path = clientAnnotation.get((CharSequence)"path", String.class).orElse(null);
            String clientKey = this.computeClientKey(clientId, path);
            this.clients.remove(clientKey);
            httpClient.close();
            return null;
        }
        Optional httpMethodMapping = context.getAnnotationTypeByStereotype(HttpMethodMapping.class);
        if (!context.hasStereotype(HttpMethodMapping.class) || httpClient == null) return context.proceed();
        AnnotationValue mapping = context.getAnnotation(HttpMethodMapping.class);
        String uri = (String)mapping.getRequiredValue(String.class);
        if (StringUtils.isEmpty((CharSequence)uri)) {
            uri = "/" + context.getMethodName();
        }
        Class annotationType = (Class)httpMethodMapping.get();
        HttpMethod httpMethod = HttpMethod.valueOf((String)annotationType.getSimpleName().toUpperCase());
        ReturnType returnType = context.getReturnType();
        Class javaReturnType = returnType.getType();
        UriMatchTemplate uriTemplate = UriMatchTemplate.of((String)"");
        if (uri.length() != 1 || uri.charAt(0) != '/') {
            uriTemplate = uriTemplate.nest((CharSequence)uri);
        }
        Map paramMap = context.getParameterValueMap();
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        List uriVariables = uriTemplate.getVariableNames();
        boolean variableSatisfied = uriVariables.isEmpty() || uriVariables.containsAll(paramMap.keySet());
        Object body = null;
        Map parameters = context.getParameters();
        Argument[] arguments = context.getArguments();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(3);
        List headerAnnotations = context.getAnnotationValuesByType(Header.class);
        for (AnnotationValue headerAnnotation : headerAnnotations) {
            String headerName = headerAnnotation.get((CharSequence)"name", String.class).orElse(null);
            String string = headerAnnotation.getValue(String.class).orElse(null);
            if (!StringUtils.isNotEmpty((CharSequence)headerName) || !StringUtils.isNotEmpty((CharSequence)string)) continue;
            headers.put(headerName, string);
        }
        ArrayList cookies = new ArrayList();
        ArrayList<Argument> bodyArguments = new ArrayList<Argument>();
        ConversionService conversionService = ConversionService.SHARED;
        for (Argument argument : arguments) {
            Object v;
            String argumentName = argument.getName();
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            MutableArgumentValue value2 = (MutableArgumentValue)parameters.get(argumentName);
            Object definedValue = value2.getValue();
            if (paramMap.containsKey(argumentName) && annotationMetadata.hasStereotype(Format.class) && (v = paramMap.get(argumentName)) != null) {
                paramMap.put(argumentName, conversionService.convert(v, ConversionContext.of(String.class).with(argument.getAnnotationMetadata())));
            }
            if (definedValue == null) {
                definedValue = argument.getAnnotationMetadata().getValue(Bindable.class, "defaultValue", String.class).orElse(null);
            }
            if (definedValue == null && !argument.isAnnotationPresent(Nullable.class)) {
                throw new IllegalArgumentException(String.format("Null values are not allowed to be passed to client methods (%s). Add @javax.validation.Nullable if that is the desired behavior", context.getExecutableMethod().toString()));
            }
            if (argument.isAnnotationPresent(Body.class)) {
                body = definedValue;
                continue;
            }
            if (annotationMetadata.isAnnotationPresent(Header.class)) {
                void var34_58;
                String string = annotationMetadata.getValue(Header.class, String.class).orElse(null);
                if (StringUtils.isEmpty((CharSequence)string)) {
                    String string2 = NameUtils.hyphenate((String)argumentName);
                }
                void var35_76 = var34_58;
                conversionService.convert(definedValue, String.class).ifPresent(arg_0 -> HttpClientIntroductionAdvice.lambda$intercept$1(headers, (String)var35_76, arg_0));
                continue;
            }
            if (annotationMetadata.isAnnotationPresent(CookieValue.class)) {
                void var34_61;
                String string = annotationMetadata.getValue(CookieValue.class, String.class).orElse(null);
                if (StringUtils.isEmpty((CharSequence)string)) {
                    String string3 = argumentName;
                }
                void var35_77 = var34_61;
                conversionService.convert(definedValue, String.class).ifPresent(arg_0 -> HttpClientIntroductionAdvice.lambda$intercept$2(cookies, (String)var35_77, arg_0));
                continue;
            }
            if (annotationMetadata.isAnnotationPresent(QueryValue.class)) {
                String string = annotationMetadata.getValue(QueryValue.class, String.class).orElse(null);
                conversionService.convert(definedValue, ConversionContext.of(String.class).with(annotationMetadata)).ifPresent(o -> {
                    if (!StringUtils.isEmpty((CharSequence)string)) {
                        paramMap.put(string, o);
                        queryParams.put(string, (String)o);
                    } else {
                        queryParams.put(argumentName, (String)o);
                    }
                });
                continue;
            }
            if (uriVariables.contains(argumentName)) continue;
            bodyArguments.add(argument);
        }
        if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod)) {
            if (body == null && !bodyArguments.isEmpty()) {
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                for (Argument bodyArgument : bodyArguments) {
                    String argumentName = bodyArgument.getName();
                    MutableArgumentValue value3 = (MutableArgumentValue)parameters.get(argumentName);
                    linkedHashMap.put(argumentName, value3.getValue());
                }
                body = linkedHashMap;
            }
            if (body != null && !variableSatisfied) {
                if (body instanceof Map) {
                    paramMap.putAll((Map)body);
                } else {
                    BeanMap beanMap = BeanMap.of(body);
                    for (Map.Entry entry : beanMap.entrySet()) {
                        String k = (String)entry.getKey();
                        Object v = entry.getValue();
                        if (v == null) continue;
                        paramMap.put(k, v);
                    }
                }
            }
        }
        uri = uriTemplate.expand(paramMap);
        uriVariables.forEach(queryParams::remove);
        MutableHttpRequest request = HttpRequest.create((HttpMethod)httpMethod, (String)this.appendQuery(uri, queryParams));
        if (body != null) {
            request.body(body);
            Object[] objectArray = context.getValue(Produces.class, MediaType[].class).orElse(DEFAULT_ACCEPT_TYPES);
            if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                request.contentType((MediaType)objectArray[0]);
            }
        }
        request.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, (Object)this.resolveTemplate((AnnotationValue<Client>)clientAnnotation, uriTemplate.toString()));
        String string = clientAnnotation.getValue(String.class).orElse(null);
        Argument<JsonError> errorType = clientAnnotation.get((CharSequence)"errorType", Class.class).map(Argument::of).orElse(HttpClient.DEFAULT_ERROR_TYPE);
        request.setAttribute((CharSequence)HttpAttributes.SERVICE_ID, (Object)string);
        if (!headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                request.header((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        cookies.forEach(arg_0 -> ((MutableHttpRequest)request).cookie(arg_0));
        MediaType[] acceptTypes = context.getValue(Consumes.class, MediaType[].class).orElse(DEFAULT_ACCEPT_TYPES);
        boolean isFuture = CompletableFuture.class.isAssignableFrom(javaReturnType);
        final Class methodDeclaringType = declaringType;
        if (Publishers.isConvertibleToPublisher((Class)javaReturnType) || isFuture) {
            void var35_82;
            void var34_74;
            boolean isSingle = Publishers.isSingle((Class)javaReturnType) || isFuture || context.getValue(Consumes.class, "single", Boolean.class).orElse(false) != false;
            Argument publisherArgument = returnType.asArgument().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            final Class argumentType = publisherArgument.getType();
            if (HttpResponse.class.isAssignableFrom(argumentType) || HttpStatus.class.isAssignableFrom(argumentType)) {
                isSingle = true;
            }
            if (!isSingle && httpClient instanceof StreamingHttpClient) {
                StreamingHttpClient streamingHttpClient = (StreamingHttpClient)httpClient;
                if (!Void.class.isAssignableFrom(argumentType)) {
                    request.accept(acceptTypes);
                }
                if (HttpResponse.class.isAssignableFrom(argumentType) || Void.class.isAssignableFrom(argumentType)) {
                    Publisher<HttpResponse<ByteBuffer<?>>> publisher = streamingHttpClient.exchangeStream(request);
                } else {
                    boolean isEventStream = Arrays.asList(acceptTypes).contains(MediaType.TEXT_EVENT_STREAM_TYPE);
                    if (isEventStream && streamingHttpClient instanceof SseClient) {
                        SseClient sseClient = (SseClient)((Object)streamingHttpClient);
                        if (publisherArgument.getType() == Event.class) {
                            Publisher publisher = sseClient.eventStream(request, publisherArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT));
                        } else {
                            Flowable flowable = Flowable.fromPublisher(sseClient.eventStream(request, publisherArgument)).map(Event::getData);
                        }
                    } else {
                        boolean isJson = this.isJsonParsedMediaType(acceptTypes);
                        if (isJson) {
                            Publisher publisher = streamingHttpClient.jsonStream(request, publisherArgument);
                        } else {
                            Publisher<ByteBuffer<?>> byteBufferPublisher = streamingHttpClient.dataStream(request);
                            if (argumentType == ByteBuffer.class) {
                                Publisher<ByteBuffer<?>> publisher = byteBufferPublisher;
                            } else {
                                if (!conversionService.canConvert(ByteBuffer.class, argumentType)) throw new ConfigurationException("Cannot create the generated HTTP client's required return type, since no TypeConverter from ByteBuffer to " + argumentType + " is registered");
                                Flowable flowable = Flowable.fromPublisher(byteBufferPublisher).map(value -> conversionService.convert(value, argumentType).get());
                            }
                        }
                    }
                }
            } else if (Void.class.isAssignableFrom(argumentType)) {
                Publisher publisher = httpClient.exchange(request, null, errorType);
            } else {
                request.accept(acceptTypes);
                if (HttpResponse.class.isAssignableFrom(argumentType)) {
                    Publisher publisher = httpClient.exchange(request, publisherArgument, errorType);
                } else {
                    Publisher publisher = httpClient.retrieve(request, publisherArgument, errorType);
                }
            }
            if (isFuture) {
                final CompletableFuture completableFuture = new CompletableFuture();
                var34_74.subscribe((Subscriber)new CompletionAwareSubscriber<Object>(){
                    AtomicReference<Object> reference = new AtomicReference();

                    protected void doOnSubscribe(Subscription subscription) {
                        subscription.request(1L);
                    }

                    protected void doOnNext(Object message) {
                        if (!Void.class.isAssignableFrom(argumentType)) {
                            this.reference.set(message);
                        }
                    }

                    protected void doOnError(Throwable t) {
                        HttpClientResponseException e;
                        if (t instanceof HttpClientResponseException && (e = (HttpClientResponseException)((Object)t)).getStatus() == HttpStatus.NOT_FOUND) {
                            completableFuture.complete(null);
                            return;
                        }
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Client [" + methodDeclaringType.getName() + "] received HTTP error response: " + t.getMessage(), t);
                        }
                        completableFuture.completeExceptionally(t);
                    }

                    protected void doOnComplete() {
                        completableFuture.complete(this.reference.get());
                    }
                });
                return completableFuture;
            }
            Object t = conversionService.convert((Object)var34_74, javaReturnType).orElseThrow(() -> new HttpClientException("Cannot convert response publisher to Reactive type (Unsupported Reactive type): " + javaReturnType));
            for (ReactiveClientResultTransformer transformer : this.transformers) {
                Object object = transformer.transform(var35_82);
            }
            return var35_82;
        }
        BlockingHttpClient blockingHttpClient = httpClient.toBlocking();
        if (Void.TYPE != javaReturnType) {
            request.accept(acceptTypes);
        }
        if (HttpResponse.class.isAssignableFrom(javaReturnType)) {
            return blockingHttpClient.exchange(request, returnType.asArgument().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT), errorType);
        }
        if (Void.TYPE == javaReturnType) {
            blockingHttpClient.exchange(request, null, errorType);
            return null;
        }
        try {
            return blockingHttpClient.retrieve(request, returnType.asArgument(), errorType);
        }
        catch (RuntimeException t) {
            if (!(t instanceof HttpClientResponseException) || ((HttpClientResponseException)((Object)t)).getStatus() != HttpStatus.NOT_FOUND) throw t;
            if (javaReturnType != Optional.class) return null;
            return Optional.empty();
        }
    }

    private boolean isJsonParsedMediaType(MediaType[] acceptTypes) {
        return Arrays.stream(acceptTypes).anyMatch(mediaType -> mediaType.equals((Object)MediaType.APPLICATION_JSON_STREAM_TYPE) || mediaType.getExtension().equals("json") || this.jsonMediaTypeCodec.getMediaTypes().contains(mediaType));
    }

    private String resolveTemplate(AnnotationValue<Client> clientAnnotation, String templateString) {
        String path = clientAnnotation.get((CharSequence)"path", String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return path + templateString;
        }
        String value = clientAnnotation.getValue(String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)value) && value.startsWith("/")) {
            return value + templateString;
        }
        return templateString;
    }

    private HttpClient getClient(MethodInvocationContext<Object, Object> context, AnnotationValue<Client> clientAnn) {
        String path;
        String clientId = clientAnn.getValue(String.class).orElse(null);
        String clientKey = this.computeClientKey(clientId, path = (String)clientAnn.get((CharSequence)"path", String.class).orElse(null));
        if (clientKey == null) {
            return null;
        }
        return this.clients.computeIfAbsent(clientKey, integer -> {
            HttpClient clientBean = this.beanContext.findBean(HttpClient.class, Qualifiers.byName((String)clientId)).orElse(null);
            if (null != clientBean) {
                return clientBean;
            }
            LoadBalancer loadBalancer = this.loadBalancerResolver.resolve(clientId).orElseThrow(() -> new HttpClientException("Invalid service reference [" + clientId + "] specified to @Client"));
            String contextPath = null;
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                contextPath = path;
            } else if (StringUtils.isNotEmpty((CharSequence)clientId) && clientId.startsWith("/")) {
                contextPath = clientId;
            } else if (loadBalancer instanceof FixedLoadBalancer) {
                contextPath = ((FixedLoadBalancer)loadBalancer).getUrl().getPath();
            }
            Optional clientSpecificConfig = this.beanContext.findBean(HttpClientConfiguration.class, Qualifiers.byName((String)clientId));
            Class<HttpClientConfiguration> defaultConfiguration = clientAnn.get((CharSequence)"configuration", Class.class).orElse(HttpClientConfiguration.class);
            HttpClientConfiguration configuration = clientSpecificConfig.orElseGet(() -> (HttpClientConfiguration)this.beanContext.getBean(defaultConfiguration));
            HttpClient client = (HttpClient)this.beanContext.createBean(HttpClient.class, new Object[]{loadBalancer, configuration, contextPath});
            if (client instanceof DefaultHttpClient) {
                DefaultHttpClient defaultClient = (DefaultHttpClient)client;
                defaultClient.setClientIdentifiers(clientId);
                AnnotationValue jacksonFeatures = context.findAnnotation(JacksonFeatures.class).orElse(null);
                if (jacksonFeatures != null) {
                    DeserializationFeature[] disabledDeserializationFeatures;
                    SerializationFeature[] disabledSerializationFeatures;
                    DeserializationFeature[] enabledDeserializationFeatures;
                    SerializationFeature[] enabledSerializationFeatures;
                    MediaTypeCodec existing;
                    Optional existingCodec = defaultClient.getMediaTypeCodecRegistry().findCodec(MediaType.APPLICATION_JSON_TYPE);
                    ObjectMapper objectMapper = null;
                    if (existingCodec.isPresent() && (existing = (MediaTypeCodec)existingCodec.get()) instanceof JsonMediaTypeCodec) {
                        objectMapper = ((JsonMediaTypeCodec)existing).getObjectMapper().copy();
                    }
                    if (objectMapper == null) {
                        objectMapper = new ObjectMapperFactory().objectMapper(Optional.empty(), Optional.empty());
                    }
                    if ((enabledSerializationFeatures = (SerializationFeature[])jacksonFeatures.get((CharSequence)"enabledSerializationFeatures", SerializationFeature[].class).orElse(null)) != null) {
                        for (SerializationFeature serializationFeature : enabledSerializationFeatures) {
                            objectMapper.configure(serializationFeature, true);
                        }
                    }
                    if ((enabledDeserializationFeatures = (DeserializationFeature[])jacksonFeatures.get((CharSequence)"enabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
                        for (DeserializationFeature serializationFeature : enabledDeserializationFeatures) {
                            objectMapper.configure(serializationFeature, true);
                        }
                    }
                    if ((disabledSerializationFeatures = (SerializationFeature[])jacksonFeatures.get((CharSequence)"disabledSerializationFeatures", SerializationFeature[].class).orElse(null)) != null) {
                        for (SerializationFeature serializationFeature : disabledSerializationFeatures) {
                            objectMapper.configure(serializationFeature, false);
                        }
                    }
                    if ((disabledDeserializationFeatures = (DeserializationFeature[])jacksonFeatures.get((CharSequence)"disabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
                        for (DeserializationFeature feature : disabledDeserializationFeatures) {
                            objectMapper.configure(feature, false);
                        }
                    }
                    defaultClient.setMediaTypeCodecRegistry(MediaTypeCodecRegistry.of((MediaTypeCodec[])new MediaTypeCodec[]{new JsonMediaTypeCodec(objectMapper, (ApplicationConfiguration)this.beanContext.getBean(ApplicationConfiguration.class), (CodecConfiguration)this.beanContext.findBean(CodecConfiguration.class, Qualifiers.byName((String)"json")).orElse(null))}));
                }
            }
            return client;
        });
    }

    private String computeClientKey(String clientId, String path) {
        if (StringUtils.isEmpty((CharSequence)clientId)) {
            return null;
        }
        String clientKey = clientId;
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            clientKey = clientKey + path;
        }
        return clientKey;
    }

    private String appendQuery(String uri, Map<String, String> queryParams) {
        if (!queryParams.isEmpty()) {
            try {
                URI oldUri = new URI(uri);
                StringBuilder sb = new StringBuilder(oldUri.getQuery() == null ? "" : oldUri.getQuery());
                if (sb.length() > 0) {
                    sb.append('&');
                }
                Iterator<Map.Entry<String, String>> iterator = queryParams.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    sb.append(entry.getKey());
                    sb.append('=');
                    sb.append(entry.getValue());
                    if (!iterator.hasNext()) continue;
                    sb.append('&');
                }
                return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), sb.toString(), oldUri.getFragment()).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uri;
    }

    @Override
    @PreDestroy
    public void close() {
        for (HttpClient client : this.clients.values()) {
            client.close();
        }
    }

    private static /* synthetic */ void lambda$intercept$2(List cookies, String finalCookieName, String o) {
        cookies.add(new NettyCookie(finalCookieName, o));
    }

    private static /* synthetic */ void lambda$intercept$1(Map headers, String finalHeaderName, String o) {
        headers.put(finalHeaderName, o);
    }
}

