/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.ssl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.ClientSslConfiguration;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

@Singleton
@Internal
public class NettyClientSslBuilder
extends SslBuilder<SslContext> {
    @Inject
    public NettyClientSslBuilder(ClientSslConfiguration ssl, ResourceResolver resourceResolver) {
        super((SslConfiguration)ssl, resourceResolver);
    }

    public NettyClientSslBuilder(SslConfiguration ssl) {
        super(ssl, new ResourceResolver());
    }

    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    public Optional<SslContext> build() {
        if (!this.ssl.isEnabled()) {
            return Optional.empty();
        }
        SslContextBuilder sslBuilder = SslContextBuilder.forClient().keyManager(this.getKeyManagerFactory()).trustManager(this.getTrustManagerFactory());
        if (this.ssl.getProtocols().isPresent()) {
            sslBuilder.protocols((String[])this.ssl.getProtocols().get());
        }
        if (this.ssl.getCiphers().isPresent()) {
            sslBuilder = sslBuilder.ciphers(Arrays.asList((Object[])this.ssl.getCiphers().get()));
        }
        if (this.ssl.getClientAuthentication().isPresent()) {
            ClientAuthentication clientAuth = (ClientAuthentication)this.ssl.getClientAuthentication().get();
            if (clientAuth == ClientAuthentication.NEED) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.REQUIRE);
            } else if (clientAuth == ClientAuthentication.WANT) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.OPTIONAL);
            }
        }
        try {
            return Optional.of(sslBuilder.build());
        }
        catch (SSLException ex) {
            throw new SslConfigurationException("An error occurred while setting up SSL", (Throwable)ex);
        }
    }

    protected KeyManagerFactory getKeyManagerFactory() {
        try {
            if (this.getKeyStore().isPresent()) {
                return super.getKeyManagerFactory();
            }
            return null;
        }
        catch (Exception ex) {
            throw new SslConfigurationException((Throwable)ex);
        }
    }

    protected TrustManagerFactory getTrustManagerFactory() {
        try {
            if (this.getTrustStore().isPresent()) {
                return super.getTrustManagerFactory();
            }
            return InsecureTrustManagerFactory.INSTANCE;
        }
        catch (Exception ex) {
            throw new SslConfigurationException((Throwable)ex);
        }
    }
}

