/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.convert.format.ReadableBytes;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.server.cors.CorsOriginConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import java.io.File;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

@ConfigurationProperties(value="micronaut.server", cliPrefix={""})
public class HttpServerConfiguration {
    public static final int DEFAULT_PORT = 8080;
    public static final String PREFIX = "micronaut.server";
    public static final int DEFAULT_RANDOM_PORT = -1;
    public static final long DEFAULT_MAX_REQUEST_SIZE = 0xA00000L;
    public static final long DEFAULT_READ_IDLE_TIME_MINUTES = 5L;
    public static final long DEFAULT_WRITE_IDLE_TIME_MINUTES = 5L;
    public static final boolean DEFAULT_DATEHEADER = true;
    public static final long DEFAULT_IDLE_TIME_MINUTES = 5L;
    public static final boolean DEFAULT_LOG_HANDLED_EXCEPTIONS = false;
    private Integer port;
    private String host;
    private Integer readTimeout;
    private long maxRequestSize = 0xA00000L;
    private Duration readIdleTimeout = null;
    private Duration writeIdleTimeout = null;
    private Duration idleTimeout = Duration.of(5L, ChronoUnit.MINUTES);
    private MultipartConfiguration multipart = new MultipartConfiguration();
    private CorsConfiguration cors = new CorsConfiguration();
    private String serverHeader;
    private boolean dateHeader = true;
    private boolean logHandledExceptions = false;
    private final ApplicationConfiguration applicationConfiguration;
    private Charset defaultCharset;

    public HttpServerConfiguration() {
        this.applicationConfiguration = new ApplicationConfiguration();
    }

    @Inject
    public HttpServerConfiguration(ApplicationConfiguration applicationConfiguration) {
        if (applicationConfiguration != null) {
            this.defaultCharset = applicationConfiguration.getDefaultCharset();
        }
        this.applicationConfiguration = applicationConfiguration;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    public Optional<String> getHost() {
        return Optional.ofNullable(this.host);
    }

    public Optional<Integer> getReadTimeout() {
        return Optional.ofNullable(this.readTimeout);
    }

    public MultipartConfiguration getMultipart() {
        return this.multipart;
    }

    public CorsConfiguration getCors() {
        return this.cors;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public Duration getReadIdleTimeout() {
        return Optional.ofNullable(this.readIdleTimeout).orElse(this.idleTimeout);
    }

    public Duration getWriteIdleTimeout() {
        return Optional.ofNullable(this.writeIdleTimeout).orElse(this.idleTimeout);
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public Optional<String> getServerHeader() {
        return Optional.ofNullable(this.serverHeader);
    }

    public boolean isDateHeader() {
        return this.dateHeader;
    }

    public boolean isLogHandledExceptions() {
        return this.logHandledExceptions;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public void setMaxRequestSize(@ReadableBytes long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public void setReadIdleTimeout(Duration readIdleTimeout) {
        this.readIdleTimeout = readIdleTimeout;
    }

    public void setWriteIdleTimeout(Duration writeIdleTimeout) {
        this.writeIdleTimeout = writeIdleTimeout;
    }

    public void setIdleTimeout(Duration idleTimeout) {
        if (idleTimeout != null) {
            this.idleTimeout = idleTimeout;
        }
    }

    public void setMultipart(MultipartConfiguration multipart) {
        this.multipart = multipart;
    }

    public void setCors(CorsConfiguration cors) {
        this.cors = cors;
    }

    public void setDateHeader(boolean dateHeader) {
        this.dateHeader = dateHeader;
    }

    public void setLogHandledExceptions(boolean logHandledExceptions) {
        this.logHandledExceptions = logHandledExceptions;
    }

    @ConfigurationProperties(value="cors")
    public static class CorsConfiguration
    implements Toggleable {
        public static final boolean DEFAULT_ENABLED = false;
        private boolean enabled = false;
        private Map<String, CorsOriginConfiguration> configurations = Collections.emptyMap();
        private Map<String, CorsOriginConfiguration> defaultConfiguration = new LinkedHashMap<String, CorsOriginConfiguration>(1);

        public boolean isEnabled() {
            return this.enabled;
        }

        public Map<String, CorsOriginConfiguration> getConfigurations() {
            if (this.enabled && this.configurations.isEmpty()) {
                if (this.defaultConfiguration.isEmpty()) {
                    this.defaultConfiguration.put("default", new CorsOriginConfiguration());
                }
                return this.defaultConfiguration;
            }
            return this.configurations;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setConfigurations(Map<String, CorsOriginConfiguration> configurations) {
            this.configurations = configurations;
        }
    }

    @ConfigurationProperties(value="multipart")
    public static class MultipartConfiguration
    implements Toggleable {
        public static final boolean DEFAULT_ENABLED = false;
        public static final long DEFAULT_MAX_FILE_SIZE = 0x100000L;
        public static final boolean DEFAULT_DISK = false;
        private File location;
        private long maxFileSize = 0x100000L;
        private boolean enabled = false;
        private boolean disk = false;

        public Optional<File> getLocation() {
            return Optional.ofNullable(this.location);
        }

        public long getMaxFileSize() {
            return this.maxFileSize;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisk() {
            return this.disk;
        }

        public void setLocation(File location) {
            this.location = location;
        }

        public void setMaxFileSize(@ReadableBytes long maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDisk(boolean disk) {
            this.disk = disk;
        }
    }
}

