/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateos.JsonError;
import io.micronaut.http.hateos.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import java.net.URI;
import javax.inject.Singleton;

@Singleton
@Primary
@Produces
public class ConversionErrorHandler
implements ExceptionHandler<ConversionErrorException, HttpResponse> {
    @Override
    public HttpResponse handle(HttpRequest request, ConversionErrorException exception) {
        JsonError error = new JsonError(exception.getMessage());
        error.path('/' + exception.getArgument().getName());
        error.link(Link.SELF, Link.of((URI)request.getUri()));
        return HttpResponse.badRequest((Object)error);
    }
}

