/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateos.JsonError;
import io.micronaut.http.hateos.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import java.net.URI;
import javax.inject.Singleton;

@Produces(value={"application/json"})
@Singleton
public class JsonExceptionHandler
implements ExceptionHandler<JsonProcessingException, Object> {
    @Override
    public Object handle(HttpRequest request, JsonProcessingException exception) {
        MutableHttpResponse response = HttpResponse.status((HttpStatus)HttpStatus.BAD_REQUEST, (String)"Invalid JSON");
        JsonError body = new JsonError("Invalid JSON: " + exception.getMessage());
        body.link(Link.SELF, Link.of((URI)request.getUri()));
        response.body((Object)body);
        return response;
    }
}

