/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.types.files;

import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.types.files.SystemFileCustomizableResponseType;
import java.io.File;

public class AttachedFile
extends SystemFileCustomizableResponseType {
    private static final String HEADER_VALUE = "attachment; filename=\"%s\"";
    private final String filename;
    private final String attachmentName;

    public AttachedFile(File file) {
        this(file, file.getName());
    }

    public AttachedFile(File file, String filename) {
        super(file);
        this.filename = file.getName();
        this.attachmentName = filename;
    }

    public void process(MutableHttpResponse response) {
        response.header((CharSequence)"Content-Disposition", (CharSequence)String.format(HEADER_VALUE, this.attachmentName));
    }

    @Override
    public String getName() {
        return this.filename;
    }
}

