/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.context;

import io.micronaut.http.HttpRequest;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public final class ServerRequestContext {
    private static final ThreadLocal<HttpRequest> REQUEST = new ThreadLocal();

    private ServerRequestContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void with(HttpRequest request, Runnable runnable) {
        HttpRequest existing = REQUEST.get();
        boolean isSet = false;
        try {
            if (existing == null) {
                isSet = true;
                REQUEST.set(request);
            }
            runnable.run();
        }
        finally {
            if (isSet) {
                REQUEST.remove();
            }
        }
    }

    public static Runnable instrument(HttpRequest request, Runnable runnable) {
        return () -> ServerRequestContext.with(request, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T with(HttpRequest request, Supplier<T> callable) {
        HttpRequest existing = REQUEST.get();
        boolean isSet = false;
        try {
            if (existing == null) {
                isSet = true;
                REQUEST.set(request);
            }
            T t = callable.get();
            return t;
        }
        finally {
            if (isSet) {
                REQUEST.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T with(HttpRequest request, Callable<T> callable) throws Exception {
        HttpRequest existing = REQUEST.get();
        boolean isSet = false;
        try {
            if (existing == null) {
                isSet = true;
                REQUEST.set(request);
            }
            T t = callable.call();
            return t;
        }
        finally {
            if (isSet) {
                REQUEST.remove();
            }
        }
    }

    public static <T> Optional<HttpRequest<T>> currentRequest() {
        return Optional.ofNullable(REQUEST.get());
    }
}

