/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.JavaAnnotationMetadataBuilder;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.caffeine.cache.Cache;
import io.micronaut.caffeine.cache.Caffeine;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.Internal;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class AnnotationUtils {
    private static final int CACHE_SIZE = 100;
    private static final Cache<Element, AnnotationMetadata> annotationMetadataCache = Caffeine.newBuilder().maximumSize(100L).build();
    private final Elements elementUtils;
    private final Messager messager;
    private final Types types;
    private final ModelUtils modelUtils;
    private final Filer filer;

    protected AnnotationUtils(Elements elementUtils, Messager messager, Types types, ModelUtils modelUtils, Filer filer) {
        this.elementUtils = elementUtils;
        this.messager = messager;
        this.types = types;
        this.modelUtils = modelUtils;
        this.filer = filer;
    }

    protected boolean hasStereotype(Element element, Class<? extends Annotation> stereotype) {
        return this.hasStereotype(element, stereotype.getName());
    }

    protected boolean hasStereotype(Element element, String ... stereotypes) {
        return this.hasStereotype(element, Arrays.asList(stereotypes));
    }

    protected boolean hasStereotype(Element element, List<String> stereotypes) {
        if (element == null) {
            return false;
        }
        if (stereotypes.contains(element.toString())) {
            return true;
        }
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata(element);
        for (String stereotype : stereotypes) {
            if (!annotationMetadata.hasStereotype(stereotype)) continue;
            return true;
        }
        return false;
    }

    public AnnotationMetadata getAnnotationMetadata(Element element) {
        AnnotationMetadata metadata = (AnnotationMetadata)annotationMetadataCache.getIfPresent((Object)element);
        if (metadata == null) {
            metadata = this.newAnnotationBuilder().build(element);
            annotationMetadataCache.put((Object)element, (Object)metadata);
        }
        return metadata;
    }

    public AnnotationMetadata getAnnotationMetadata(Element parent, Element element) {
        return this.newAnnotationBuilder().buildForParent(parent, element);
    }

    public boolean isAnnotated(ExecutableElement method) {
        List<? extends AnnotationMirror> annotationMirrors = method.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            String typeName = annotationMirror.getAnnotationType().toString();
            if (AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(typeName)) continue;
            return true;
        }
        return false;
    }

    public JavaAnnotationMetadataBuilder newAnnotationBuilder() {
        return new JavaAnnotationMetadataBuilder(this.elementUtils, this.messager, this, this.types, this.modelUtils, this.filer);
    }

    @Internal
    static void invalidateCache() {
        annotationMetadataCache.invalidateAll();
    }
}

