/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class ModelUtils {
    private final Elements elementUtils;
    private final Types typeUtils;

    protected ModelUtils(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    final TypeElement classElementFor(Element element) {
        while (!element.getKind().isClass() && !element.getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element;
    }

    String simpleBinaryNameFor(TypeElement typeElement) {
        Name elementBinaryName = this.elementUtils.getBinaryName(typeElement);
        PackageElement packageElement = this.elementUtils.getPackageOf(typeElement);
        String packageName = packageElement.getQualifiedName().toString();
        return elementBinaryName.toString().replaceFirst(packageName + "\\.", "");
    }

    Optional<ExecutableElement> findSetterMethodFor(Element field) {
        String name = field.getSimpleName().toString();
        name = name.replaceFirst("^(is).+", "");
        String setterName = this.setterNameFor(name);
        TypeElement typeElement = this.classElementFor(field);
        List<? extends Element> elements = typeElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(elements);
        return methods.stream().filter(method -> {
            String methodName = method.getSimpleName().toString();
            if (setterName.equals(methodName)) {
                Set<Modifier> modifiers = method.getModifiers();
                return !modifiers.contains((Object)Modifier.STATIC) && modifiers.contains((Object)Modifier.PUBLIC) || !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PROTECTED);
            }
            return false;
        }).findFirst();
    }

    String setterNameFor(String fieldName) {
        return "set" + NameUtils.capitalize((String)fieldName);
    }

    @Nullable
    ExecutableElement concreteConstructorFor(TypeElement classElement) {
        List<ExecutableElement> constructors = this.findNonPrivateConstructors(classElement);
        if (constructors.isEmpty()) {
            return null;
        }
        if (constructors.size() == 1) {
            return constructors.get(0);
        }
        Optional<ExecutableElement> element = constructors.stream().filter(ctor -> Objects.nonNull(ctor.getAnnotation(Inject.class))).findFirst();
        if (!element.isPresent()) {
            element = constructors.stream().filter(ctor -> ctor.getModifiers().contains((Object)Modifier.PUBLIC)).findFirst();
        }
        return element.orElse(null);
    }

    List<ExecutableElement> findNonPrivateConstructors(TypeElement classElement) {
        List<ExecutableElement> ctors = ElementFilter.constructorsIn(classElement.getEnclosedElements());
        return ctors.stream().filter(ctor -> !ctor.getModifiers().contains((Object)Modifier.PRIVATE)).collect(Collectors.toList());
    }

    Class<?> classOfPrimitiveFor(String primitiveType) {
        return (Class)ClassUtils.getPrimitiveType((String)primitiveType).orElseThrow(() -> new IllegalArgumentException("Unknown primitive type: " + primitiveType));
    }

    Class<?> classOfPrimitiveArrayFor(String primitiveType) {
        try {
            switch (primitiveType) {
                case "byte": {
                    return Class.forName("[B");
                }
                case "int": {
                    return Class.forName("[I");
                }
                case "short": {
                    return Class.forName("[S");
                }
                case "long": {
                    return Class.forName("[J");
                }
                case "float": {
                    return Class.forName("[F");
                }
                case "double": {
                    return Class.forName("[D");
                }
                case "char": {
                    return Class.forName("[C");
                }
                case "boolean": {
                    return Class.forName("[Z");
                }
            }
            throw new IllegalArgumentException("Unsupported primitive type " + primitiveType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    TypeElement superClassFor(TypeElement element) {
        TypeMirror superclass = element.getSuperclass();
        if (superclass.getKind() == TypeKind.NONE) {
            return null;
        }
        DeclaredType kind = (DeclaredType)superclass;
        return (TypeElement)kind.asElement();
    }

    Object resolveTypeReference(TypeElement typeElement) {
        TypeMirror type = typeElement.asType();
        if (type != null) {
            return this.resolveTypeReference(type);
        }
        return typeElement.getQualifiedName().toString();
    }

    boolean isObjectClass(TypeElement element) {
        return element.getSuperclass().getKind() == TypeKind.NONE;
    }

    @Nullable
    Object resolveTypeReference(Element element) {
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return this.resolveTypeReferenceForTypeElement(typeElement);
        }
        return null;
    }

    String resolveTypeReferenceForTypeElement(TypeElement typeElement) {
        return JavaModelUtils.getClassName((TypeElement)typeElement);
    }

    String resolveTypeName(TypeMirror type) {
        Object reference = this.resolveTypeReference(type);
        if (reference instanceof Class) {
            return ((Class)reference).getName();
        }
        return reference.toString();
    }

    Object resolveTypeReference(TypeMirror type) {
        TypeMirror erased;
        Element element;
        Object result = Void.TYPE;
        if (type.getKind().isPrimitive()) {
            result = this.resolvePrimitiveTypeReference(type);
        } else if (type.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)type;
            TypeMirror componentType = arrayType.getComponentType();
            if (componentType.getKind().isPrimitive()) {
                result = this.classOfPrimitiveArrayFor(this.resolvePrimitiveTypeReference(componentType).getName());
            } else {
                TypeMirror erased2 = this.typeUtils.erasure(componentType);
                Element e = this.typeUtils.asElement(erased2);
                if (e instanceof TypeElement) {
                    result = this.resolveTypeReferenceForTypeElement((TypeElement)e) + "[]";
                }
            }
        } else if (type.getKind() != TypeKind.VOID && type.getKind() != TypeKind.ERROR && (element = this.typeUtils.asElement(erased = this.typeUtils.erasure(type))) instanceof TypeElement) {
            TypeElement te = (TypeElement)element;
            result = this.resolveTypeReferenceForTypeElement(te);
        }
        return result;
    }

    boolean isPackagePrivate(Element element) {
        Set<Modifier> modifiers = element.getModifiers();
        return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    boolean isInheritedAndNotPublic(TypeElement concreteClass, TypeElement declaringClass, Element methodOrField) {
        PackageElement packageOfDeclaringClass = this.elementUtils.getPackageOf(declaringClass);
        PackageElement packageOfConcreteClass = this.elementUtils.getPackageOf(concreteClass);
        return declaringClass != concreteClass && !packageOfDeclaringClass.getQualifiedName().equals(packageOfConcreteClass.getQualifiedName()) && (this.isProtected(methodOrField) || !this.isPublic(methodOrField));
    }

    Optional<ExecutableElement> overridingOrHidingMethod(ExecutableElement overridden, TypeElement classElement) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.elementUtils.getAllMembers(classElement));
        for (ExecutableElement method : methods) {
            if (method.equals(overridden) || !method.getSimpleName().equals(overridden.getSimpleName())) continue;
            return Optional.of(method);
        }
        TypeElement superClass = this.superClassFor(classElement);
        if (superClass != null && !this.isObjectClass(superClass)) {
            return this.overridingOrHidingMethod(overridden, superClass);
        }
        return Optional.empty();
    }

    boolean isPrivate(Element element) {
        return element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    boolean isProtected(Element element) {
        return element.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    boolean isPublic(Element element) {
        return element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    boolean isOptional(TypeMirror mirror) {
        return this.typeUtils.erasure(mirror).toString().equals(Optional.class.getName());
    }

    private Class resolvePrimitiveTypeReference(TypeMirror type) {
        Class<?> result;
        if (type instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)type;
            result = this.classOfPrimitiveFor(dt.asElement().getSimpleName().toString());
        } else {
            result = this.classOfPrimitiveFor(type.toString());
        }
        return result;
    }
}

