/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.context.annotation.Configuration;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.writer.BeanConfigurationWriter;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleElementVisitor8;

@SupportedAnnotationTypes(value={"io.micronaut.context.annotation.Configuration"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@Internal
public class PackageConfigurationInjectProcessor
extends AbstractInjectAnnotationProcessor {
    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return false;
        }
        AnnotationElementScanner scanner = new AnnotationElementScanner();
        Set<? extends Element> elements = roundEnv.getRootElements();
        ElementFilter.packagesIn(elements).forEach(element -> element.accept(scanner, element));
        try {
            this.classWriterOutputVisitor.finish();
        }
        catch (Exception e) {
            this.error("I/O error occurred writing META-INF services information: %s", e);
        }
        return false;
    }

    class AnnotationElementScanner
    extends SimpleElementVisitor8<Object, Object> {
        AnnotationElementScanner() {
        }

        @Override
        public Object visitPackage(PackageElement packageElement, Object p) {
            Object aPackage = super.visitPackage(packageElement, p);
            if (PackageConfigurationInjectProcessor.this.annotationUtils.hasStereotype((Element)packageElement, Configuration.class)) {
                String packageName = packageElement.getQualifiedName().toString();
                BeanConfigurationWriter writer = new BeanConfigurationWriter(packageName, PackageConfigurationInjectProcessor.this.annotationUtils.getAnnotationMetadata(packageElement));
                try {
                    writer.accept(PackageConfigurationInjectProcessor.this.classWriterOutputVisitor);
                }
                catch (IOException e) {
                    PackageConfigurationInjectProcessor.this.error("I/O error occurred writing Configuration for package [%s]: %s", packageElement, e);
                }
            }
            return aPackage;
        }
    }
}

