/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.annotation.processing.visitor.LoadedVisitor;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner8;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class TypeElementVisitorProcessor
extends AbstractInjectAnnotationProcessor {
    private boolean executed = false;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.executed) {
            return false;
        }
        JavaVisitorContext visitorContext = new JavaVisitorContext(this.processingEnv.getMessager(), this.elementUtils, this.annotationUtils, this.typeUtils, this.modelUtils, this.filer);
        SoftServiceLoader serviceLoader = SoftServiceLoader.load(TypeElementVisitor.class, (ClassLoader)this.getClass().getClassLoader());
        HashMap<String, LoadedVisitor> loadedVisitors = new HashMap<String, LoadedVisitor>();
        for (ServiceDefinition definition : serviceLoader) {
            if (!definition.isPresent()) continue;
            TypeElementVisitor visitor = (TypeElementVisitor)definition.load();
            try {
                loadedVisitors.put(definition.getName(), new LoadedVisitor(visitor, visitorContext, this.genericUtils, this.processingEnv));
            }
            catch (NoClassDefFoundError | TypeNotPresentException throwable) {}
        }
        for (LoadedVisitor loadedVisitor : loadedVisitors.values()) {
            try {
                loadedVisitor.getVisitor().start((VisitorContext)visitorContext);
            }
            catch (Throwable e) {
                this.error("Error initializing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
            }
        }
        TypeElement groovyObjectTypeElement = this.elementUtils.getTypeElement("groovy.lang.GroovyObject");
        TypeMirror groovyObjectType = groovyObjectTypeElement != null ? groovyObjectTypeElement.asType() : null;
        roundEnv.getRootElements().stream().filter(element -> element.getKind().isClass() || element.getKind().isInterface()).map(this.modelUtils::classElementFor).filter(typeElement -> groovyObjectType == null || !this.typeUtils.isAssignable(typeElement.asType(), groovyObjectType)).forEach(typeElement -> {
            String className = typeElement.getQualifiedName().toString();
            List<LoadedVisitor> matchedVisitors = loadedVisitors.values().stream().filter(v -> v.matches((TypeElement)typeElement)).collect(Collectors.toList());
            typeElement.accept(new ElementVisitor((TypeElement)typeElement, matchedVisitors), className);
        });
        for (LoadedVisitor loadedVisitor : loadedVisitors.values()) {
            try {
                loadedVisitor.getVisitor().finish((VisitorContext)visitorContext);
            }
            catch (Throwable e) {
                this.error("Error finalizing type visitor [%s]: %s", loadedVisitor.getVisitor(), e.getMessage());
            }
        }
        this.executed = true;
        return false;
    }

    private class ElementVisitor
    extends ElementScanner8<Object, Object> {
        private final TypeElement concreteClass;
        private final List<LoadedVisitor> visitors;

        ElementVisitor(TypeElement concreteClass, List<LoadedVisitor> visitors) {
            this.concreteClass = concreteClass;
            this.visitors = visitors;
        }

        @Override
        public Object visitType(TypeElement classElement, Object o) {
            boolean shouldVisit;
            AnnotationMetadata typeAnnotationMetadata = TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(classElement);
            this.visitors.forEach(v -> v.visit(classElement, typeAnnotationMetadata));
            Element enclosingElement = classElement.getEnclosingElement();
            boolean bl = shouldVisit = !enclosingElement.getKind().isClass() || this.concreteClass.getQualifiedName().equals(classElement.getQualifiedName());
            if (shouldVisit) {
                TypeElement superClass = TypeElementVisitorProcessor.this.modelUtils.superClassFor(classElement);
                if (superClass != null && !TypeElementVisitorProcessor.this.modelUtils.isObjectClass(superClass)) {
                    superClass.accept(this, o);
                }
                return this.scan(classElement.getEnclosedElements(), o);
            }
            return null;
        }

        @Override
        public Object visitExecutable(ExecutableElement executableElement, Object o) {
            AnnotationMetadata methodAnnotationMetadata = TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(executableElement);
            if (executableElement.getSimpleName().toString().equals("<init>")) {
                this.visitors.forEach(v -> v.visit(executableElement, methodAnnotationMetadata));
                return null;
            }
            this.visitors.stream().filter(v -> v.matches(methodAnnotationMetadata)).forEach(v -> v.visit(executableElement, methodAnnotationMetadata));
            return null;
        }

        @Override
        public Object visitVariable(VariableElement variable, Object o) {
            if (variable.getKind() != ElementKind.FIELD) {
                return null;
            }
            AnnotationMetadata fieldAnnotationMetadata = TypeElementVisitorProcessor.this.annotationUtils.getAnnotationMetadata(variable);
            this.visitors.stream().filter(v -> v.matches(fieldAnnotationMetadata)).forEach(v -> v.visit(variable, fieldAnnotationMetadata));
            return null;
        }
    }
}

