/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaEnumElement;
import io.micronaut.annotation.processing.visitor.JavaPrimitiveElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.annotation.processing.visitor.JavaVoidElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import java.util.List;
import java.util.Locale;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public abstract class AbstractJavaElement
implements Element,
AnnotationMetadataDelegate {
    private final javax.lang.model.element.Element element;
    private final AnnotationMetadata annotationMetadata;

    AbstractJavaElement(javax.lang.model.element.Element element, AnnotationMetadata annotationMetadata) {
        this.element = element;
        this.annotationMetadata = annotationMetadata;
    }

    private boolean hasModifier(Modifier modifier) {
        return this.element.getModifiers().contains((Object)modifier);
    }

    public String getName() {
        return this.element.getSimpleName().toString();
    }

    public boolean isAbstract() {
        return this.hasModifier(Modifier.ABSTRACT);
    }

    public boolean isStatic() {
        return this.hasModifier(Modifier.STATIC);
    }

    public boolean isPublic() {
        return this.hasModifier(Modifier.PUBLIC);
    }

    public boolean isPrivate() {
        return this.hasModifier(Modifier.PRIVATE);
    }

    public boolean isFinal() {
        return this.hasModifier(Modifier.FINAL);
    }

    public boolean isProtected() {
        return this.hasModifier(Modifier.PROTECTED);
    }

    public Object getNativeType() {
        return this.element;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public String toString() {
        return this.element.toString();
    }

    protected ClassElement mirrorToClassElement(TypeMirror returnType, JavaVisitorContext visitorContext) {
        if (returnType instanceof NoType) {
            return new JavaVoidElement();
        }
        if (returnType instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)returnType;
            javax.lang.model.element.Element e = dt.asElement();
            List<? extends TypeMirror> typeArguments = dt.getTypeArguments();
            if (e instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)e;
                if (typeElement.getKind() == ElementKind.ENUM) {
                    return new JavaEnumElement(typeElement, visitorContext.getAnnotationUtils().getAnnotationMetadata(typeElement), visitorContext, typeArguments);
                }
                return new JavaClassElement(typeElement, visitorContext.getAnnotationUtils().getAnnotationMetadata(typeElement), visitorContext, typeArguments);
            }
        } else {
            ArrayType at;
            TypeMirror componentType;
            ClassElement arrayType;
            if (returnType instanceof PrimitiveType) {
                PrimitiveType pt = (PrimitiveType)returnType;
                return JavaPrimitiveElement.valueOf(pt.toString().toUpperCase(Locale.ENGLISH));
            }
            if (returnType instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)returnType;
                TypeMirror upperBound = tv.getUpperBound();
                ClassElement classElement = this.mirrorToClassElement(upperBound, visitorContext);
                if (classElement != null) {
                    return classElement;
                }
                return this.mirrorToClassElement(tv.getLowerBound(), visitorContext);
            }
            if (returnType instanceof ArrayType && (arrayType = this.mirrorToClassElement(componentType = (at = (ArrayType)returnType).getComponentType(), visitorContext)) != null) {
                if (arrayType instanceof JavaPrimitiveElement) {
                    JavaPrimitiveElement jpe = (JavaPrimitiveElement)arrayType;
                    return jpe.toArray();
                }
                return new JavaClassElement((TypeElement)arrayType.getNativeType(), (AnnotationMetadata)arrayType, visitorContext){

                    @Override
                    public boolean isArray() {
                        return true;
                    }
                };
            }
        }
        return null;
    }
}

