/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaPropertyElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PropertyElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class JavaClassElement
extends AbstractJavaElement
implements ClassElement {
    private final TypeElement classElement;
    private final JavaVisitorContext visitorContext;
    private final List<? extends TypeMirror> typeArguments;

    JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        super(classElement, annotationMetadata);
        this.classElement = classElement;
        this.visitorContext = visitorContext;
        this.typeArguments = Collections.emptyList();
    }

    JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, List<? extends TypeMirror> typeArguments) {
        super(classElement, annotationMetadata);
        this.classElement = classElement;
        this.visitorContext = visitorContext;
        this.typeArguments = typeArguments;
    }

    @Override
    public boolean isAbstract() {
        return this.classElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isInterface() {
        return this.classElement.getKind() == ElementKind.INTERFACE;
    }

    public List<PropertyElement> getBeanProperties() {
        final LinkedHashMap props = new LinkedHashMap();
        final LinkedHashMap fields = new LinkedHashMap();
        this.classElement.asType().accept(new PublicMethodVisitor<Object, Object>(){

            @Override
            protected boolean isAcceptable(Element element) {
                Set<Modifier> modifiers;
                if (element.getKind() == ElementKind.FIELD) {
                    return true;
                }
                if (element.getKind() == ElementKind.METHOD && element instanceof ExecutableElement && (modifiers = element.getModifiers()).contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.ABSTRACT)) {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    String methodName = executableElement.getSimpleName().toString();
                    if (methodName.contains("$")) {
                        return false;
                    }
                    if (NameUtils.isGetterName((String)methodName) && executableElement.getParameters().size() == 0) {
                        return true;
                    }
                    return NameUtils.isSetterName((String)methodName) && executableElement.getParameters().size() == 1;
                }
                return false;
            }

            @Override
            protected void accept(DeclaredType type, Element element, Object o) {
                if (element instanceof VariableElement) {
                    fields.put(element.getSimpleName().toString(), (VariableElement)element);
                    return;
                }
                ExecutableElement executableElement = (ExecutableElement)element;
                String methodName = executableElement.getSimpleName().toString();
                if (NameUtils.isGetterName((String)methodName) && executableElement.getParameters().size() == 0) {
                    String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
                    ClassElement getterReturnType = JavaClassElement.this.mirrorToClassElement(executableElement.getReturnType(), JavaClassElement.this.visitorContext);
                    if (getterReturnType != null) {
                        TypeMirror typeMirror;
                        ClassElement setterParameterType;
                        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, x$0 -> new BeanPropertyData((String)x$0));
                        beanPropertyData.type = getterReturnType;
                        beanPropertyData.getter = executableElement;
                        if (!(beanPropertyData.setter == null || (setterParameterType = JavaClassElement.this.mirrorToClassElement(typeMirror = beanPropertyData.setter.getParameters().get(0).asType(), JavaClassElement.this.visitorContext)) != null && setterParameterType.getName().equals(getterReturnType.getName()))) {
                            beanPropertyData.setter = null;
                        }
                    }
                } else if (NameUtils.isSetterName((String)methodName) && executableElement.getParameters().size() == 1) {
                    String propertyName = NameUtils.getPropertyNameForSetter((String)methodName);
                    TypeMirror typeMirror = executableElement.getParameters().get(0).asType();
                    ClassElement setterParameterType = JavaClassElement.this.mirrorToClassElement(typeMirror, JavaClassElement.this.visitorContext);
                    if (setterParameterType != null) {
                        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, x$0 -> new BeanPropertyData((String)x$0));
                        ClassElement propertyType = beanPropertyData.type;
                        if (propertyType != null) {
                            if (propertyType.getName().equals(setterParameterType.getName())) {
                                beanPropertyData.setter = executableElement;
                            }
                        } else {
                            beanPropertyData.setter = executableElement;
                        }
                    }
                }
            }
        }, null);
        if (!props.isEmpty()) {
            ArrayList<2> propertyElements = new ArrayList<2>();
            for (Map.Entry entry : props.entrySet()) {
                String propertyName = (String)entry.getKey();
                final BeanPropertyData value = (BeanPropertyData)entry.getValue();
                VariableElement fieldElement = (VariableElement)fields.get(propertyName);
                if (value.getter == null) continue;
                AnnotationMetadata annotationMetadata = fieldElement != null ? this.visitorContext.getAnnotationUtils().getAnnotationMetadata(fieldElement, value.getter) : this.visitorContext.getAnnotationUtils().getAnnotationMetadata(value.getter);
                JavaPropertyElement propertyElement = new JavaPropertyElement(value.getter, annotationMetadata, propertyName, value.type, value.setter == null){

                    public Optional<String> getDocumentation() {
                        Elements elements = JavaClassElement.this.visitorContext.getElements();
                        String docComment = elements.getDocComment(value.getter);
                        return Optional.ofNullable(docComment);
                    }
                };
                propertyElements.add(propertyElement);
            }
            return Collections.unmodifiableList(propertyElements);
        }
        return Collections.emptyList();
    }

    public boolean isArray() {
        return this.classElement.asType().getKind() == TypeKind.ARRAY;
    }

    @Override
    public String getName() {
        return this.classElement.getQualifiedName().toString();
    }

    public boolean isAssignable(String type) {
        TypeElement otherElement = this.visitorContext.getElements().getTypeElement(type);
        if (otherElement != null) {
            Types types = this.visitorContext.getTypes();
            TypeMirror thisType = types.erasure(this.classElement.asType());
            TypeMirror thatType = types.erasure(otherElement.asType());
            return types.isAssignable(thisType, thatType);
        }
        return false;
    }

    public Map<String, ClassElement> getTypeArguments() {
        List<? extends TypeParameterElement> typeParameters = this.classElement.getTypeParameters();
        if (typeParameters.size() == this.typeArguments.size()) {
            Iterator<? extends TypeParameterElement> tpi = typeParameters.iterator();
            Iterator<? extends TypeMirror> tai = this.typeArguments.iterator();
            LinkedHashMap<String, ClassElement> map = new LinkedHashMap<String, ClassElement>();
            while (tpi.hasNext()) {
                TypeParameterElement tpe = tpi.next();
                TypeMirror typeMirror = tai.next();
                ClassElement classElement = this.mirrorToClassElement(typeMirror, this.visitorContext);
                if (classElement == null) continue;
                map.put(tpe.toString(), classElement);
            }
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    private class BeanPropertyData {
        ClassElement type;
        ExecutableElement getter;
        ExecutableElement setter;
        final String propertyName;

        public BeanPropertyData(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

